/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Eigenschaften;
import jafuffy.Fenster;
import jafuffy.Grafik;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

class Oberflaeche
extends UIManager
implements ActionListener {
    private static final String LAFS = "/LaF/lafs.xml";
    private static final int WUERFELRAHMENBREITE = 6;
    static final ArrayList<Image> LOGOS = new ArrayList();
    private final Eigenschaften eigenschaften;
    private Fenster fenster;

    static {
        LOGOS.add(Grafik.bild("Fensterlogo16.png"));
        LOGOS.add(Grafik.bild("Fensterlogo32.png"));
        LOGOS.add(Grafik.bild("Fensterlogo48.png"));
    }

    static void starteJetzt(Runnable r) {
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void starteSpaeter(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    Oberflaeche(Eigenschaften eigenschaften) {
        this.eigenschaften = eigenschaften;
        this.setzeLookAndFeel(eigenschaften.getProperty("LookAndFeel"));
        this.installiereLookAndFeel(this.parseEinstellungsDatei());
        this.wendeAnpassungenAn();
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        JComponent komponente = (JComponent)event.getSource();
        String laf = (String)komponente.getClientProperty("laf");
        this.setzeLookAndFeel(laf);
        if (this.fenster != null && JOptionPane.showConfirmDialog(this.fenster, "Fenstergr\u00f6\u00dfe an Look & Feel anpassen?", "JaFuffy (Frage)", 0) == 0) {
            this.fenster.pack();
        }
    }

    private void installiereLookAndFeel(TreeMap<String, String> lafs) {
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (Map.Entry<String, String> laf : lafs.entrySet()) {
            boolean vorhanden = false;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if (laf.getKey().equals(info.getClassName())) {
                    vorhanden = true;
                }
                ++n2;
            }
            if (vorhanden) continue;
            UIManager.installLookAndFeel(laf.getValue(), laf.getKey());
        }
    }

    private TreeMap<String, String> parseEinstellungsDatei() {
        TreeMap<String, String> lafs = new TreeMap<String, String>();
        XMLInputFactory fabrik = XMLInputFactory.newInstance();
        try {
            XMLEvent event;
            InputStream stream = Oberflaeche.class.getResourceAsStream(LAFS);
            XMLEventReader leser = fabrik.createXMLEventReader(stream);
            while (!(event = leser.nextEvent()).isStartElement() && leser.hasNext()) {
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "lafs") {
                boolean geoeffnet = false;
                String implementierung = null;
                String name = null;
                while (leser.hasNext()) {
                    event = leser.nextEvent();
                    if (!geoeffnet) {
                        if (!event.isStartElement() || event.asStartElement().getName().getLocalPart() != "laf") continue;
                        geoeffnet = true;
                        continue;
                    }
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "name") {
                        event = leser.nextEvent();
                        name = event.asCharacters().getData();
                    }
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart() == "class") {
                        event = leser.nextEvent();
                        implementierung = event.asCharacters().getData();
                    }
                    if (!event.isEndElement() || event.asEndElement().getName().getLocalPart() != "laf") continue;
                    lafs.put(implementierung, name);
                    geoeffnet = false;
                }
            }
        }
        catch (XMLStreamException exception) {
            exception.printStackTrace();
        }
        return lafs;
    }

    private void setzeLookAndFeel(String laf) {
        JFrame.setDefaultLookAndFeelDecorated(false);
        JDialog.setDefaultLookAndFeelDecorated(false);
        Oberflaeche.put("Table.showGrid", true);
        try {
            Oberflaeche.setLookAndFeel(laf);
            if (this.fenster != null) {
                SwingUtilities.updateComponentTreeUI(this.fenster);
            }
        }
        catch (Exception e) {
            try {
                System.out.println(e);
                laf = Oberflaeche.getCrossPlatformLookAndFeelClassName();
                Oberflaeche.setLookAndFeel(laf);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        this.eigenschaften.setProperty("LookAndFeel", laf);
    }

    private void wendeAnpassungenAn() {
        Oberflaeche.put("FileChooser.cancelButtonText", "Abbruch");
        Oberflaeche.put("FileChooser.cancelButtonToolTipText", "Abbruch der Auswahl");
        Oberflaeche.put("OptionPane.yesButtonText", "Ja");
        Oberflaeche.put("OptionPane.noButtonText", "Nein");
        Oberflaeche.put("OptionPane.cancelButtonText", "Abbruch");
        Oberflaeche.put("OptionPane.okButtonText", "OK");
        Oberflaeche.put("ToggleButton.contentMargins", new Insets(6, 6, 6, 6));
    }

    void fenster(Fenster fenster) {
        this.fenster = fenster;
    }
}

