/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Aenderungen;
import jafuffy.Auswahl;
import jafuffy.Auswertung;
import jafuffy.CEAblauf;
import jafuffy.Punkte;
import jafuffy.Spieler;
import jafuffy.Statistik;
import jafuffy.Tabzeile;
import jafuffy.Variante;
import jafuffy.Wuerfel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;

class Turnier
extends Aenderungen<CEAblauf>
implements ActionListener {
    private static final long serialVersionUID = -8157448193770055452L;
    private static final int EINTRAEGE = 13;
    static final String BASIS = "Turnier";
    static final String ENDUNG = "obj";
    static final int WUERFEL = 5;
    static final int RUNDEN = 3;
    private final Wuerfel[] wuerfel;
    private final ArrayList<Spieler> spieler;
    private final Auswertung auswertung;
    private final Class<? extends Auswahl> auswahlklasse;
    private final int anzahl;
    private final Beginner beginnmodus;
    private Spieler aktiver;
    private int gespielt = 0;
    private int eintraege = 0;
    private int teilnehmer = 0;
    private int startindex;
    private ArrayList<Integer>[] verlauf;
    private int[] turnierstand;
    private transient Statistik statistik;
    private transient Punkte punkte;
    private transient Spieler kopieAktiver;
    private transient Spieler merkerAktiver;
    private transient int merkerGespielt;
    private transient int merkerEintrag;
    private transient int merkerTeilnehmer;

    Turnier(Variante variante, ArrayList<Spieler> spieler, int startindex, Beginner beginnmodus, int anzahl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        this.spieler = spieler;
        this.startindex = startindex;
        this.beginnmodus = beginnmodus;
        this.anzahl = anzahl;
        this.wuerfel = new Wuerfel[5];
        int i = 0;
        while (i < 5) {
            this.wuerfel[i] = new Wuerfel(i + 1);
            ++i;
        }
        this.auswertung = variante.auswertungskonstruktor.newInstance(new Object[]{variante, this.wuerfel});
        this.auswahlklasse = variante.auswahlklasse;
        for (Spieler s : spieler) {
            s.vorbereiten();
        }
        this.aktiviere(startindex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        if (ac.equals("Gewuerfelt")) {
            this.wuerfle();
        } else if (ac.equals("Rueckgaengig")) {
            this.nimmZurueck();
        } else if (ac.equals("Vorschlagen")) {
            this.auswertung.vorschlagen();
        } else if (ac.equals("Setzen")) {
            this.setze(this.auswertung.analyse.bester());
        } else if (ac.equals("Beenden")) {
            this.beende();
        }
    }

    private void beendeRunde() {
        ++this.eintraege;
        this.teilnehmer = 0;
        this.statistik.beendeRunde();
    }

    private void beendeSetzen() {
        this.aktiviere((this.spieler.indexOf(this.aktiver) + 1) % this.spieler.size());
        ++this.teilnehmer;
        if (this.teilnehmer >= this.spieler.size()) {
            this.beendeRunde();
            if (this.eintraege >= 13) {
                this.aktiver.warten();
                this.auswertung.tipps(false);
                this.fireStateChanged(CEAblauf.RESULTAT);
                this.beendeSpiel();
            }
        }
        if (this.anzahl > 0 && this.gespielt == this.anzahl) {
            this.beende();
        } else if (this.gespielt == this.merkerGespielt) {
            this.auswertung.tipps(false);
            this.fireStateChanged(CEAblauf.GESETZT);
        } else {
            this.fireStateChanged(CEAblauf.SPIEL);
        }
    }

    private void beendeSpiel() {
        Spieler verlierer;
        Spieler gewinner = verlierer = this.spieler.get(0);
        for (Spieler s : this.spieler) {
            if (s.endsumme() < verlierer.endsumme()) {
                verlierer = s;
            }
            if (s.endsumme() <= gewinner.endsumme()) continue;
            gewinner = s;
        }
        switch (this.beginnmodus) {
            case VERLIERER: {
                this.startindex = this.spieler.indexOf(verlierer);
                break;
            }
            case GEWINNER: {
                this.startindex = this.spieler.indexOf(gewinner);
                break;
            }
            case REIHUM: {
                ++this.startindex;
                this.startindex %= this.spieler.size();
                break;
            }
            case ZUFALL: {
                this.startindex = new Random().nextInt(this.spieler.size());
                break;
            }
        }
        this.statistik.beendeSpiel();
        for (Spieler s : this.spieler) {
            s.vorbereiten();
        }
        this.aktiviere(this.startindex);
        ++this.gespielt;
        this.eintraege = 0;
    }

    private void merke() {
        this.merkerTeilnehmer = this.teilnehmer;
        this.merkerEintrag = this.eintraege;
        this.merkerGespielt = this.gespielt;
        this.merkerAktiver = this.aktiver;
        this.kopieAktiver = this.aktiver.kopie();
    }

    private void nimmZurueck() {
        if (this.eintraege != this.merkerEintrag) {
            this.statistik.rueckgaengig();
        }
        this.aktiver.warten();
        this.teilnehmer = this.merkerTeilnehmer;
        this.eintraege = this.merkerEintrag;
        this.gespielt = this.merkerGespielt;
        this.spieler.set(this.spieler.indexOf(this.merkerAktiver), this.kopieAktiver);
        this.aktiver = this.kopieAktiver;
        this.aktiver.reaktivieren();
        this.auswertung.gewuerfelt(this.aktiver);
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            w.setSelected(false);
            ++n2;
        }
        this.auswertung.tipps(false);
        this.fireStateChanged(CEAblauf.RUECKGAENGIG);
    }

    private void wuerfle() {
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            if (w.isSelected()) {
                w.wirf();
            }
            ++n2;
        }
        this.fireStateChanged(CEAblauf.WUERFELN);
        this.aktiver.wuerfeln();
        this.auswertung.gewuerfelt(this.aktiver);
        this.auswertung.tipps(false);
        this.fireStateChanged(CEAblauf.GEWUERFELT);
    }

    Spieler aktiver() {
        return this.aktiver;
    }

    void aktiviere(int index) {
        this.aktiver = this.spieler.get(index);
        this.aktiver.aktivieren();
    }

    int anzahl() {
        return this.anzahl;
    }

    Auswahl auswahl() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return Auswahl.auswahlkonstruktor(this.auswahlklasse).newInstance(this);
    }

    Auswertung auswertung() {
        return this.auswertung;
    }

    void beende() {
        if (this.aktiver != null) {
            this.auswertung.tipps(false);
            this.fireStateChanged(this.gespielt == this.anzahl && this.anzahl > 0 ? CEAblauf.ENDE : CEAblauf.ABBRUCH);
            this.aktiver.warten();
            this.aktiver = null;
        }
    }

    boolean beendet() {
        return this.aktiver == null;
    }

    String beschreibung() {
        String s = new String("Mitspieler: ");
        ListIterator<Spieler> iterator = this.spieler.listIterator();
        while (iterator.hasNext()) {
            s = String.valueOf(s) + iterator.next().toString();
            s = iterator.hasNext() ? String.valueOf(s) + ", " : String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + "\n" + this.auswertung.toString() + ". " + (this.spieler.size() > 1 ? (Object)((Object)this.beginnmodus) + ". " : "");
        s = String.valueOf(s) + (this.anzahl == 0 ? "Beliebig viele Spiele." : "Im " + (this.gespielt + 1) + ". von " + this.anzahl + (this.anzahl != 1 ? " Spielen" : " Spiel") + ".");
        return s;
    }

    int nummer() {
        return this.gespielt + 1;
    }

    void pausiere() {
        this.fireStateChanged(CEAblauf.PAUSE);
    }

    Punkte punkte() {
        return this.punkte;
    }

    void setze(Tabzeile eintrag) {
        this.setze(eintrag, this.auswertung.wert(eintrag));
    }

    void setze(Tabzeile eintrag, int wert) {
        this.merke();
        this.aktiver.setzen(eintrag, wert);
        this.beendeSetzen();
    }

    void setzeFort(Statistik statistik) {
        this.statistik = statistik;
        this.auswertung.gewuerfelt(this.aktiver);
        this.punkte = new Punkte(this.spieler, this.auswertung);
        if (this.verlauf == null) {
            statistik.verfolgen(this.auswertung.variante.ordinal(), this.anzahl, this.spieler, this.auswertung.mittelwert(), this.auswertung.abweichung());
            this.verlauf = statistik.verlauf();
            this.turnierstand = statistik.turnierstand();
        } else {
            statistik.verfolgen(this.auswertung.variante.ordinal(), this.anzahl, this.spieler, this.auswertung.mittelwert(), this.auswertung.abweichung(), this.verlauf, this.turnierstand);
        }
    }

    ArrayList<Spieler> spieler() {
        return this.spieler;
    }

    Spieler spieler(int i) {
        return this.spieler.get(i);
    }

    void starte() {
        this.fireStateChanged(CEAblauf.START);
    }

    Wuerfel[] wuerfel() {
        return this.wuerfel;
    }

    Wuerfel wuerfel(int i) {
        return this.wuerfel[i];
    }

    static enum Beginner {
        VERLIERER("Verlierer beginnt"),
        GEWINNER("Gewinner beginnt"),
        DERSELBE("Immer derselbe beginnt"),
        REIHUM("Beginner reihum ausw\u00e4hlen"),
        ZUFALL("Beginner zuf\u00e4llig ausw\u00e4hlen");

        private final String bezeichnung;

        private Beginner(String bezeichnung) {
            this.bezeichnung = bezeichnung;
        }

        public String toString() {
            return this.bezeichnung;
        }
    }
}

