/******************************************************************************
 ** $Id: Variante.java 591 2014-08-02 12:29:04Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.lang.reflect.Constructor;

/**
 * Varianten mit unterschiedlichen Spielregeln und passenden Auswahlmglichkeiten.
 */
enum Variante {
    KLASSISCH(AuswertungKlassisch.REGEL, AuswertungKlassisch.class, AuswahlKlassisch.class), IMHIEB(
            AuswertungImHieb.REGEL, AuswertungImHieb.class, AuswahlImHieb.class), ERWEITERT(
            AuswertungErweitert.REGEL, AuswertungErweitert.class, AuswahlErweitert.class);
    final String spielregelname;
    final Class<? extends Auswertung> auswertungsklasse;
    final Constructor<? extends Auswertung> auswertungskonstruktor;
    final Class<? extends Auswahl> auswahlklasse;
    final Constructor<? extends Auswahl> auswahlkonstruktor;

    Variante(String spielregelname, Class<? extends Auswertung> auswertungsklasse,
            Class<? extends Auswahl> auswahlklasse) {
        this.spielregelname = spielregelname;
        this.auswertungsklasse = auswertungsklasse;
        this.auswertungskonstruktor = Auswertung.auswertungskonstruktor(auswertungsklasse);
        this.auswahlklasse = auswahlklasse;
        this.auswahlkonstruktor = Auswahl.auswahlkonstruktor(auswahlklasse);
    }

    @Override
    public String toString() {
        return spielregelname;
    }

}
