/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.AuswertungKlassisch;
import jafuffy.Tabzeile;
import jafuffy.Variante;
import jafuffy.Wuerfel;

class AuswertungImHieb
extends AuswertungKlassisch {
    private static final long serialVersionUID = 6730182688848850948L;
    private static final int IM_HIEB_MIN = 5;
    private static final int IM_HIEB_MAX = 30;
    private static final int MITTELWERT = 235;
    private static final int ABWEICHUNG = 45;
    static final String REGEL = "Im-Hieb-Regeln";
    private boolean imHiebNachricht = false;
    private Tabzeile imHiebEintrag;

    public AuswertungImHieb(Variante variante, Wuerfel[] wuerfel) {
        super(variante, wuerfel);
    }

    @Override
    public String toString() {
        return REGEL;
    }

    void imHiebNachrichtDeaktiv() {
        this.imHiebNachricht = false;
    }

    void imHiebNachrichtAktiv(Tabzeile imHiebEintrag) {
        this.imHiebEintrag = imHiebEintrag;
        this.imHiebNachricht = true;
    }

    boolean imHieb(Tabzeile eintrag) {
        return eintrag.unten() && eintrag != Tabzeile.CHANCE && this.spieler.einmalig() && super.wert(eintrag) > 0;
    }

    @Override
    int mittelwert() {
        return 235;
    }

    @Override
    int abweichung() {
        return 45;
    }

    @Override
    int wert(Tabzeile eintrag) {
        if (this.imHieb(eintrag)) {
            return super.wert(eintrag) + (eintrag == Tabzeile.JAFUFFY ? 30 : 5);
        }
        return super.wert(eintrag);
    }

    @Override
    String text(Tabzeile eintrag) {
        return this.imHiebNachricht && eintrag == this.imHiebEintrag ? "Im Hieb!" : null;
    }
}

