/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Fenster;
import jafuffy.Oberflaeche;
import jafuffy.Pfad;
import jafuffy.Signal;
import jafuffy.Starter;
import jafuffy.Turnier;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Fortsetzung
extends JDialog
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    private static final int DELAY = 2500;
    private static final int SICHERUNGEN = 4;
    private static final String[] SCHACHTNAMEN = new String[]{"Automatische Sicherung", "Manuelle Sicherung A", "Manuelle Sicherung B", "Manuelle Sicherung C", "Manuelle Sicherung D"};
    private static final String LEER = "Leer";
    private static final String FORTSETZUNG = "Fortsetzung";
    private static final int ABSTAND_OK = 32;
    private static final int DIALOGRAHMENABSTAND = 4;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private final Starter starter = new Starter();
    private final Fenster fenster;
    private final JPanel dialog = new JPanel(new CardLayout());
    private final JRadioButton[] rButtons = new JRadioButton[5];
    private final ButtonGroup gruppe = new ButtonGroup();
    private final JTextArea[] textfelder = new JTextArea[5];
    private final JDialog bestaetigung = new JDialog(this);
    private String altesDatum;
    private String alterText;
    private boolean speichern;
    private int gewaehlt = -1;
    private int gewaehltVorAbbruch;
    private final JButton fortsetzen = new JButton("Turnier abspeichern");
    private final JButton ok = new JButton("Keine Sicherungen vorhanden!");
    private JMenuItem menuepunkt;
    private Turnier turnier;

    static String beschreibung(File stand) {
        String beschreibung = "\n";
        if (stand.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(stand));
                beschreibung = (String)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return beschreibung;
    }

    static String datum(File stand) {
        return stand.exists() ? DateFormat.getDateTimeInstance(3, 3, Locale.GERMANY).format(new Date(stand.lastModified())) : "---";
    }

    Fortsetzung(Fenster fenster) {
        this.fenster = fenster;
        UIManager.addPropertyChangeListener(this);
        this.dialog.add((Component)this.baueLeerfeld(), LEER);
        this.dialog.add((Component)this.baueFortsetzungsfeld(), FORTSETZUNG);
        JScrollPane pane = new JScrollPane(this.dialog);
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setContentPane(pane);
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String ac = event.getActionCommand();
        if (ac.equals("Speichern")) {
            this.sichere(this.gewaehlt, this.turnier, this.textfelder[this.gewaehlt].getText());
            this.menuepunkt.setEnabled(true);
        } else if (ac.equals("Fortsetzen")) {
            this.setVisible(false);
            this.starter.los(this.lade(this.gewaehlt));
            this.menuepunkt.setEnabled(this.gewaehlt != 0);
        } else if (ac.equals("OK")) {
            this.setVisible(false);
        } else if (ac.length() == 1) {
            int neu;
            int alt = this.gewaehlt;
            this.gewaehlt = neu = Integer.parseInt(ac);
            if (this.speichern) {
                this.fortsetzen.setEnabled(true);
                this.rButtons[alt].setText(this.altesDatum);
                this.textfelder[alt].setEditable(false);
                this.textfelder[alt].setEnabled(false);
                this.textfelder[alt].setText(this.alterText);
                this.altesDatum = this.rButtons[neu].getText();
                this.rButtons[neu].setText(String.valueOf(SCHACHTNAMEN[neu]) + " von jetzt");
                this.textfelder[neu].setEditable(true);
                this.textfelder[neu].setEnabled(true);
                this.alterText = this.textfelder[neu].getText();
                this.textfelder[neu].setText(this.turnier.beschreibung());
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.starter.addActionListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            Turnier turnier = (Turnier)ce.getSource();
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    this.turnier = turnier;
                    break;
                }
                case ABBRUCH: {
                    this.sichere(0, turnier, null);
                    this.textfelder[0].setText(turnier.beschreibung());
                    break;
                }
                case ENDE: {
                    this.entferneAutomatischeSicherung();
                    this.textfelder[0].setText(null);
                    this.turnier = null;
                    break;
                }
            }
        }
    }

    private JPanel baueFortsetzungsfeld() {
        JPanel staendefeld = this.baueStaendefeld();
        staendefeld.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel leiste = this.baueLeiste();
        leiste.setBorder(new EmptyBorder(4, 0, 2, 0));
        JPanel fortsetzung = new JPanel(new BorderLayout());
        fortsetzung.setBorder(new EmptyBorder(0, 4, 0, 4));
        fortsetzung.add((Component)staendefeld, "Center");
        fortsetzung.add((Component)leiste, "South");
        return fortsetzung;
    }

    private JPanel baueLeerfeld() {
        this.baueOk();
        JPanel leer = new JPanel();
        leer.setLayout(new BoxLayout(leer, 1));
        leer.add(Box.createVerticalGlue());
        leer.add((Component)this.ok, "Center");
        leer.add(Box.createVerticalGlue());
        return leer;
    }

    private JPanel baueLeiste() {
        this.fortsetzen.addActionListener(this);
        this.fortsetzen.setActionCommand("Fortsetzen");
        JButton abbruch = new JButton("Abbruch");
        abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Fortsetzung.this.speichern) {
                    Fortsetzung.this.textfelder[Fortsetzung.this.gewaehlt].setText(Fortsetzung.this.alterText);
                }
                Fortsetzung.this.gewaehlt = Fortsetzung.this.gewaehltVorAbbruch;
                Fortsetzung.this.setVisible(false);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(this.fortsetzen);
        leiste.add(abbruch);
        return leiste;
    }

    private void baueOk() {
        this.ok.addActionListener(this);
        this.ok.setActionCommand("OK");
        this.ok.setAlignmentX(0.5f);
        this.ok.setMargin(new Insets(32, 32, 32, 32));
    }

    private JPanel baueStaendefeld() {
        int i = 0;
        while (i <= 4) {
            this.textfelder[i] = new JTextArea("\n", 2, 32);
            this.textfelder[i].setFont(new Font("Dialog", 0, 12));
            this.textfelder[i].setText(Fortsetzung.beschreibung(Pfad.datei("Turnier" + i + "." + "obj")));
            ++i;
        }
        JPanel staendefeld = new JPanel();
        staendefeld.setLayout(new BoxLayout(staendefeld, 1));
        int i2 = 0;
        while (i2 <= 4) {
            this.rButtons[i2] = new JRadioButton();
            this.rButtons[i2].addActionListener(this);
            this.rButtons[i2].setActionCommand(String.valueOf(i2));
            this.gruppe.add(this.rButtons[i2]);
            this.textfelder[i2].setToolTipText("<html><p>Beschreibt gespeicherten Turnierstand.</p><p>Kann vor dem Speichern ge\u00e4ndert werden.</p></html>");
            this.textfelder[i2].setBorder(BorderFactory.createEtchedBorder());
            this.textfelder[i2].setDisabledTextColor(Color.DARK_GRAY);
            JPanel schachtfeld = new JPanel(new BorderLayout());
            schachtfeld.add((Component)this.rButtons[i2], "North");
            schachtfeld.add((Component)this.textfelder[i2], "Center");
            staendefeld.add(Box.createVerticalStrut(2));
            staendefeld.add(schachtfeld);
            staendefeld.add(Box.createVerticalStrut(4));
            ++i2;
        }
        this.textfelder[0].setToolTipText("<html><p>Beschreibt automatisch gespeicherten Turnierstand.</p><p>Der Text wird automatisch erzeugt.</p></html>");
        return staendefeld;
    }

    private void belegeAuswahlMitDaten(String text, String cmd) {
        Vector<Integer> auswahlgruppe = new Vector<Integer>(5);
        File stand = Pfad.datei("Turnier0.obj");
        this.rButtons[0].setSelected(false);
        this.rButtons[0].setText(String.valueOf(SCHACHTNAMEN[0]) + " (" + Fortsetzung.datum(stand) + ")");
        this.rButtons[0].setToolTipText("Schacht entspricht gespeichertem Turnierstand");
        this.textfelder[0].setEditable(false);
        this.textfelder[0].setEnabled(false);
        if (!this.speichern && stand.exists()) {
            this.rButtons[0].setEnabled(true);
            auswahlgruppe.add(0);
        } else {
            this.rButtons[0].setEnabled(false);
        }
        int i = 1;
        while (i <= 4) {
            stand = Pfad.datei("Turnier" + i + "." + "obj");
            this.rButtons[i].setText(String.valueOf(SCHACHTNAMEN[i]) + " (" + Fortsetzung.datum(stand) + ")");
            this.rButtons[i].setToolTipText(this.speichern ? "W\u00e4hle Schacht aus, in den gespeichert wird" : "Schacht entspricht gespeichertem Turnierstand");
            this.rButtons[i].setSelected(false);
            this.textfelder[i].setEnabled(false);
            if (this.speichern || stand.exists()) {
                this.rButtons[i].setEnabled(true);
                auswahlgruppe.add(i);
            } else {
                this.rButtons[i].setEnabled(false);
            }
            ++i;
        }
        if (!auswahlgruppe.isEmpty()) {
            ((CardLayout)this.dialog.getLayout()).show(this.dialog, FORTSETZUNG);
            if (this.gewaehlt < 0) {
                this.pack();
                this.gewaehlt = this.speichern ? 0 : (Integer)auswahlgruppe.get(0);
            }
            this.gewaehltVorAbbruch = this.gewaehlt;
            if (this.speichern) {
                this.textfelder[this.gewaehlt].setEditable(this.gewaehlt > 0);
                this.textfelder[this.gewaehlt].setEnabled(this.gewaehlt > 0);
                this.alterText = this.textfelder[this.gewaehlt].getText();
                this.textfelder[this.gewaehlt].setText(this.turnier.beschreibung());
                this.altesDatum = this.rButtons[this.gewaehlt].getText();
                this.rButtons[this.gewaehlt].setText(String.valueOf(SCHACHTNAMEN[this.gewaehlt]) + " von jetzt");
            }
            this.rButtons[this.gewaehlt].setSelected(true);
            this.fortsetzen.setText(text);
            this.fortsetzen.setActionCommand(cmd);
            this.fortsetzen.setEnabled(!this.speichern || this.gewaehlt > 0);
            this.getRootPane().setDefaultButton(this.fortsetzen);
        } else {
            ((CardLayout)this.dialog.getLayout()).show(this.dialog, LEER);
            this.pack();
            this.getRootPane().setDefaultButton(this.ok);
        }
    }

    private void entferneAutomatischeSicherung() {
        File datei = Pfad.datei("Turnier0.obj");
        datei.delete();
    }

    private Turnier lade(int index) {
        Turnier turnier = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(Pfad.datei("Turnier" + String.valueOf(index) + "." + "obj")));
            in.readObject();
            turnier = (Turnier)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(this, "Turnier kann nicht fortgesetzt werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
        return turnier;
    }

    private void meldeSpeicherung(String text) {
        this.bestaetigung.setTitle("JaFuffy (Best\u00e4tigung)");
        this.bestaetigung.setIconImages(Oberflaeche.LOGOS);
        final JOptionPane meldung = new JOptionPane(text, 1);
        meldung.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (Fortsetzung.this.bestaetigung.isVisible() && e.getSource() == meldung && (prop.equals("value") || prop.equals("inputValue"))) {
                    Fortsetzung.this.bestaetigung.setVisible(false);
                    Fortsetzung.this.setVisible(false);
                }
            }
        });
        this.bestaetigung.setContentPane(meldung);
        this.bestaetigung.setModal(true);
        this.bestaetigung.pack();
        this.bestaetigung.setLocationRelativeTo(this.isVisible() ? this : this.fenster);
        Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Fortsetzung.this.bestaetigung.setVisible(false);
                Fortsetzung.this.setVisible(false);
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.bestaetigung.setVisible(true);
    }

    private void sichere(int index, Turnier turnier, String beschreibung) {
        if (!turnier.beendet()) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(Pfad.datei("Turnier" + String.valueOf(index) + "." + "obj")));
                out.writeObject(beschreibung == null || beschreibung.equals("") ? turnier.beschreibung() : beschreibung);
                boolean[] status = new boolean[5];
                int i = 0;
                while (i < 5) {
                    status[i] = turnier.wuerfel(i).isSelected();
                    turnier.wuerfel(i).setSelected(false);
                    ++i;
                }
                out.writeObject(turnier);
                i = 0;
                while (i < 5) {
                    turnier.wuerfel(i).setSelected(status[i]);
                    ++i;
                }
                out.close();
                if (beschreibung != null) {
                    this.meldeSpeicherung("Turnierstand erfolgreich gesichert!");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Signal.ALARM.play();
                JOptionPane.showMessageDialog(this, "Turnierstand konnte nicht gespeichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
            }
        }
    }

    void setzeFort() {
        this.speichern = false;
        this.setTitle("JaFuffy (Turnier fortsetzen...)");
        this.belegeAuswahlMitDaten("Turnier fortsetzen", "Fortsetzen");
    }

    void speichere() {
        this.speichern = true;
        this.fortsetzen.setActionCommand("Speichern");
        this.fortsetzen.doClick();
    }

    void speichere(JMenuItem menuepunkt) {
        this.menuepunkt = menuepunkt;
    }

    void speichereUnter() {
        this.speichern = true;
        this.setTitle("JaFuffy (Turnier speichern unter...)");
        this.belegeAuswahlMitDaten("Turnier abspeichern", "Speichern");
    }

    void versucheAutomatik() {
        this.starter.los(this.lade(0));
    }
}

