/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Becher;
import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Grafik;
import jafuffy.Spieler;
import jafuffy.Turnier;
import jafuffy.Wuerfelreihe;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wuerfelfeld
extends JPanel
implements ChangeListener {
    private static final String ANZEIGE = "Anzeige";
    private static final ImageIcon EINTRAG = Grafik.icon("Eintrag.gif");
    private static final ImageIcon FERTIG = Grafik.icon("Fertig.gif");
    private static final String VERSTECK = "Versteck";
    private static final ImageIcon WUERFELN = Grafik.icon("Wuerfeln.gif");
    private static final ImageIcon WUERFELN0 = Grafik.icon("Wuerfeln0.gif");
    private final Aktion aktion = new Aktion();
    private final Kontextmenue kontextmenue = new Kontextmenue();
    private final Wuerfelreihe reihe = new Wuerfelreihe(this.kontextmenue);
    private final Wuerfelrahmen wuerfelrahmen = new Wuerfelrahmen();
    private final Status status = new Status();

    Wuerfelfeld() {
        this.wuerfelrahmen.addMouseListener(this.kontextmenue);
        this.status.icon.addMouseListener(this.kontextmenue);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.aktion);
        this.add(this.wuerfelrahmen);
        this.add(this.status);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    Turnier turnier = (Turnier)ce.getSource();
                    this.starte(turnier);
                }
                case SPIEL: 
                case GESETZT: {
                    Turnier turnier = (Turnier)ce.getSource();
                    this.aktion.informiere(turnier.anzahl(), turnier.nummer());
                    this.reihe.akzeptiere(turnier.aktiver().rest());
                }
                case GEWUERFELT: 
                case RUECKGAENGIG: {
                    Turnier turnier = (Turnier)ce.getSource();
                    this.aktualisiere(turnier.aktiver());
                    break;
                }
                case VORSCHLAGEN: {
                    this.reihe.uebernehme();
                    break;
                }
                case PAUSE: {
                    this.reihe.pausiere();
                    break;
                }
                case RESULTAT: {
                    this.wuerfelrahmen.verstecke();
                    this.status.beendeSpiel();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    Turnier turnier = (Turnier)ce.getSource();
                    this.beende(turnier);
                    break;
                }
            }
        }
        this.aktion.becher.stateChanged(ce);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.kontextmenue != null) {
            SwingUtilities.updateComponentTreeUI(this.kontextmenue.auswahlkontext);
            this.kontextmenue.auswahlkontext.pack();
        }
    }

    private void aktualisiere(Spieler aktiv) {
        int rest = aktiv.rest();
        boolean neu = rest == 3;
        boolean fertig = rest == 0;
        this.reihe.aktiviere(fertig);
        this.kontextmenue.wuerfeln.setEnabled(!fertig && !neu);
        this.wuerfelrahmen.aktualisiere(neu);
        this.status.informiere(aktiv.toString(), rest, neu, fertig);
    }

    private void beende(Turnier turnier) {
        this.aktion.beende(turnier);
        this.reihe.beende();
        this.wuerfelrahmen.setEnabled(false);
        this.status.beendeTurnier();
    }

    private void starte(Turnier turnier) {
        this.aktion.starte(turnier);
        this.reihe.verwende(turnier.wuerfel());
        this.status.starteTurnier();
    }

    class Aktion
    extends JPanel {
        private static final int GROESSE = 14;
        private static final int MINDESTABSTAND = 8;
        private final Becher becher;
        private final JLabel titel;

        Aktion() {
            super(new BorderLayout());
            this.becher = new Becher();
            this.titel = new JLabel("Turnier");
            this.dekoriere();
            this.add((Component)this.baue(), "Center");
            this.setBorder(new EmptyBorder(0, 0, 8, 0));
        }

        private JPanel baue() {
            JPanel elemente = new JPanel();
            elemente.setLayout(new BoxLayout(elemente, 1));
            elemente.add(Box.createVerticalGlue());
            elemente.add(this.titel);
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(Box.createVerticalGlue());
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(this.becher);
            elemente.add(Box.createVerticalGlue());
            return elemente;
        }

        private void dekoriere() {
            this.titel.setFont(new Font("Dialog", 1, 14));
            this.titel.setAlignmentX(0.5f);
            this.titel.setHorizontalAlignment(0);
            this.becher.setActionCommand("Gewuerfelt");
        }

        void beende(Turnier turnier) {
            this.titel.setText("Turnierende");
            this.becher.removeActionListener(turnier);
        }

        void informiere(int anzahl, int nummer) {
            switch (anzahl) {
                case 0: {
                    this.titel.setText(String.valueOf(nummer) + ". Spiel im Turnier");
                    break;
                }
                case 1: {
                    this.titel.setText("Einziges Spiel im Turnier");
                    break;
                }
                default: {
                    this.titel.setText(String.valueOf(nummer) + ". von " + anzahl + " Spielen im Turnier");
                }
            }
        }

        void starte(Turnier turnier) {
            this.becher.addActionListener(turnier);
        }
    }

    private class Kontextmenue
    extends MouseAdapter {
        private static final int CLICK = 100;
        private final JPopupMenu auswahlkontext = new JPopupMenu();
        private final JMenuItem aufheben = new JMenuItem("Auswahl aufheben");
        private final JMenuItem sortieren = new JMenuItem("Sortieren");
        private final JMenuItem wuerfeln = new JMenuItem("Alle W\u00fcrfel werfen");

        public Kontextmenue() {
            this.dekoriere();
            this.verbinde();
            this.baue();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && Wuerfelfeld.this.wuerfelrahmen.isEnabled()) {
                Wuerfelfeld.this.reihe.sortiere();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && Wuerfelfeld.this.wuerfelrahmen.isEnabled()) {
                this.aufheben.setEnabled(Wuerfelfeld.this.reihe.selektiert());
                this.sortieren.setEnabled(!Wuerfelfeld.this.reihe.sortiert());
                this.auswahlkontext.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void baue() {
            this.auswahlkontext.add(this.sortieren);
            this.auswahlkontext.add(this.aufheben);
            this.auswahlkontext.addSeparator();
            this.auswahlkontext.add(this.wuerfeln);
        }

        private void dekoriere() {
            this.sortieren.setToolTipText("Der Gr\u00f6\u00dfe nach sortieren");
            this.aufheben.setToolTipText("Alle W\u00fcrfel aus dem Becher");
            this.wuerfeln.setToolTipText("Alle W\u00fcrfel in den Becher und w\u00fcrfeln");
        }

        private void verbinde() {
            this.sortieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wuerfelfeld.this.reihe.sortiere();
                }
            });
            this.aufheben.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wuerfelfeld.this.reihe.klicke();
                }
            });
            this.wuerfeln.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wuerfelfeld.this.reihe.klicke();
                    Wuerfelfeld.this.aktion.becher.doClick(100);
                }
            });
        }
    }

    class Status
    extends JPanel {
        private final JLabel icon;
        private final JLabel nachricht;
        private final JLabel restanzeige;

        Status() {
            super(new BorderLayout());
            this.icon = new JLabel(WUERFELN0);
            this.nachricht = new JLabel();
            this.restanzeige = new JLabel();
            this.dekoriere();
            this.add((Component)this.baue(), "Center");
        }

        private JPanel baue() {
            JPanel elemente = new JPanel();
            elemente.setLayout(new BoxLayout(elemente, 1));
            elemente.add(Box.createVerticalStrut(8));
            elemente.add(Box.createVerticalGlue());
            elemente.add(this.icon);
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(Box.createVerticalGlue());
            elemente.add(this.nachricht);
            elemente.add(Box.createVerticalStrut(4));
            elemente.add(this.restanzeige);
            elemente.add(Box.createVerticalGlue());
            return elemente;
        }

        private void dekoriere() {
            this.icon.setToolTipText("Sortieren durch Doppelklick, Kontextmen\u00fc");
            this.icon.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.icon.setAlignmentX(0.5f);
            this.icon.setHorizontalAlignment(0);
            this.icon.setEnabled(false);
            this.nachricht.setAlignmentX(0.5f);
            this.restanzeige.setAlignmentX(0.5f);
        }

        void beendeSpiel() {
            this.nachricht.setText(" ");
            this.restanzeige.setText(" ");
        }

        void beendeTurnier() {
            this.icon.setDisabledIcon(FERTIG);
            this.icon.setEnabled(false);
            this.nachricht.setText("Das Turnier ist beendet!");
            this.nachricht.setFont(new Font("Dialog", 3, 12));
            this.restanzeige.setText(" ");
        }

        void informiere(String name, int rest, boolean neu, boolean fertig) {
            this.icon.setEnabled(!neu);
            this.icon.setIcon(fertig ? EINTRAG : WUERFELN0);
            this.nachricht.setText(String.valueOf(name) + " ist an der Reihe!");
            if (fertig) {
                this.restanzeige.setText("Bitte in der Tabelle setzen!");
            } else {
                this.restanzeige.setText(String.valueOf(rest) + " mal darf noch gew\u00fcrfelt werden.");
            }
        }

        void starteTurnier() {
            this.icon.setDisabledIcon(WUERFELN);
        }
    }

    class Wuerfelrahmen
    extends JPanel {
        Wuerfelrahmen() {
            super(new CardLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("W\u00fcrfelauswahl"), BorderFactory.createEmptyBorder(0, 2, 4, 2)));
            this.add((Component)new JPanel(), Wuerfelfeld.VERSTECK);
            this.add((Component)Wuerfelfeld.this.reihe, Wuerfelfeld.ANZEIGE);
            this.setToolTipText("Sortieren durch Doppelklick auf freie Fl\u00e4che, Kontextmen\u00fc");
        }

        void aktualisiere(boolean neu) {
            this.setEnabled(!neu);
            ((CardLayout)this.getLayout()).show(this, neu ? Wuerfelfeld.VERSTECK : Wuerfelfeld.ANZEIGE);
        }

        void verstecke() {
            ((CardLayout)this.getLayout()).show(this, Wuerfelfeld.VERSTECK);
        }
    }
}

