/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.AuswertungKlassisch;
import jafuffy.Eigenschaften;
import jafuffy.Tabzeile;
import jafuffy.Variante;
import jafuffy.Wuerfel;

class AuswertungErweitert
extends AuswertungKlassisch {
    private static final long serialVersionUID = -5463902030609191338L;
    static final int JOKER = 100;
    private static final int MITTELWERT = 240;
    private static final int ABWEICHUNG = 60;
    private boolean joker = false;
    private boolean bonus = false;
    private boolean setzzwang = false;
    static final String REGEL = "Erweiterte Regeln";

    public AuswertungErweitert(Variante variante, Wuerfel[] wuerfel) {
        super(variante, wuerfel);
    }

    @Override
    public String toString() {
        return REGEL;
    }

    void setzzwangnachricht(boolean setzzwang) {
        if (setzzwang) {
            int w = 0;
            while (w < 5) {
                this.wuerfel[w].setEnabled(false);
                ++w;
            }
        }
        this.setzzwang = setzzwang;
    }

    void jokernachricht(boolean joker) {
        if (joker) {
            int w = 0;
            while (w < 5) {
                this.wuerfel[w].setEnabled(false);
                ++w;
            }
        }
        this.joker = joker;
    }

    void bonusnachricht(boolean bonus) {
        this.bonus = bonus;
    }

    boolean joker() {
        return super.wert(Tabzeile.JAFUFFY) > 0 && this.spieler.punkte(Tabzeile.JAFUFFY) > 0 && !this.spieler.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    boolean setzzwang() {
        return super.wert(Tabzeile.JAFUFFY) > 0 && this.spieler.punkte(Tabzeile.JAFUFFY) > 0 && this.spieler.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    @Override
    int mittelwert() {
        return 240;
    }

    @Override
    int abweichung() {
        return 60;
    }

    @Override
    int wert(Tabzeile eintrag) {
        switch (eintrag) {
            case KLEINESTRASSE: {
                return this.joker() || super.wert(eintrag) > 0 ? 30 : 0;
            }
            case GROSSESTRASSE: {
                return this.joker() || super.wert(eintrag) > 0 ? 40 : 0;
            }
            case JAFUFFY: {
                if (super.wert(eintrag) <= 0 || this.spieler.punkte(eintrag) <= 0) break;
                return this.spieler.punkte(eintrag) + 100;
            }
        }
        return super.wert(eintrag);
    }

    @Override
    String text(Tabzeile eintrag) {
        if (eintrag == Tabzeile.JAFUFFY && this.joker) {
            return "Joker!";
        }
        if (eintrag == Tabzeile.JAFUFFY && this.bonus) {
            return "Bonus!";
        }
        if (this.setzzwang && eintrag == Tabzeile.oben(this.wuerfel[0].augen())) {
            return "Gesetzt!";
        }
        return null;
    }

    @Override
    String spicker(Tabzeile eintrag) {
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.spieler.gewuerfelt() && this.joker() && eintrag == Tabzeile.JAFUFFY) {
            String text = "<p align=center><em>Joker (+ 100 Bonuspunkte)!</em></p><p>Bitte Wurf in freies Feld eintragen.</p>";
            if (this.tipps()) {
                return "<html>" + text + "<p>Kontextmen\u00fc!</p></html>";
            }
            return "<html>" + text + "</html>";
        }
        return super.spicker(eintrag);
    }
}

