/*********************************************************************
*                                                                    *
* 1997 by Stephan Kuhagen (stk@informatik.uni-bremen.de)             *
*                                                                    *
* Usage is free of limitations, do with it, what you want.           *
*                                                                    *
* Description: Nice dice, with choosable textures for the body and   *
*              the holes.                                            *
*                                                                    *
* Usage: declare DICE_TEXT1 for the texture of the body, declare     *
*        DICE_TEXT2 for the texture of the holes, include dice.inc.  *
*        Now you can use the object DICE, which is a dice with       *
*        rounded edges which fills the cube <-1,-1,-1> to <1,1,1>.   *
*                                                                    *
*********************************************************************/

#ifndef (DICE_TEXT1)
   #declare DICE_TEXT1 = 
   texture {
      pigment { color rgb<1, 0, 0> }
   }
#end

#ifndef (DICE_TEXT2)
   #declare DICE_TEXT2 = 
   texture {
      pigment { color rgb<1, 1, 0> }
   }
#end


#declare DICE =
union {

   difference {
      superellipsoid { <0.1, 0.1> }

      sphere { <0, 0, 1.25>,0.3 }

      sphere { <1.25,  0.6,  0.6>,0.3 }
      sphere { <1.25, -0.6, -0.6>,0.3 }

      sphere { < 0.6, 1.25,  0.6>,0.3 }
      sphere { <   0, 1.25,    0>,0.3 }
      sphere { <-0.6, 1.25, -0.6>,0.3 }

      sphere { <-0.45, -1.25, -0.45>,0.3 }
      sphere { <-0.45, -1.25,  0.45>,0.3 }
      sphere { < 0.45, -1.25, -0.45>,0.3 }
      sphere { < 0.45, -1.25,  0.45>,0.3 }

      sphere { <-1.25, -0.6, -0.6>,0.3 }
      sphere { <-1.25, -0.6,  0.6>,0.3 }
      sphere { <-1.25,    0,    0>,0.3 }
      sphere { <-1.25,  0.6, -0.6>,0.3 }
      sphere { <-1.25,  0.6,  0.6>,0.3 }

      sphere { <-0.45,  0.6, -1.25>,0.3 }
      sphere { <-0.45,    0, -1.25>,0.3 }
      sphere { <-0.45, -0.6, -1.25>,0.3 }
      sphere { < 0.45,  0.6, -1.25>,0.3 }
      sphere { < 0.45,    0, -1.25>,0.3 }
      sphere { < 0.45, -0.6, -1.25>,0.3 }

      texture { DICE_TEXT1 }
   }

   intersection {
      superellipsoid { <0.1, 0.1> }
      union {
         difference {
            sphere { <0, 0, 1.25>,0.3 }
            sphere { <0, 0, 1.25>,0.29 }
         }

         difference {
            sphere { <1.25,  0.6,  0.6>,0.3 }
            sphere { <1.25,  0.6,  0.6>,0.29 }
         }
         difference {
            sphere { <1.25, -0.6, -0.6>,0.3 }
            sphere { <1.25, -0.6, -0.6>,0.29 }
         }

         difference {
            sphere { < 0.6, 1.25,  0.6>,0.3 }
            sphere { < 0.6, 1.25,  0.6>,0.29 }
         }
         difference {
            sphere { <   0, 1.25,    0>,0.3 }
            sphere { <   0, 1.25,    0>,0.29 }
         }
         difference {
            sphere { <-0.6, 1.25, -0.6>,0.3 }
            sphere { <-0.6, 1.25, -0.6>,0.29 }
         }

         difference {
            sphere { <-0.45, -1.25, -0.45>,0.3 }
            sphere { <-0.45, -1.25, -0.45>,0.29 }
         }
         difference {
            sphere { <-0.45, -1.25,  0.45>,0.3 }
            sphere { <-0.45, -1.25,  0.45>,0.29 }
         }
         difference {
            sphere { < 0.45, -1.25, -0.45>,0.3 }
            sphere { < 0.45, -1.25, -0.45>,0.29 }
         }
         difference {
            sphere { < 0.45, -1.25,  0.45>,0.3 }
            sphere { < 0.45, -1.25,  0.45>,0.29 }
         }

         difference {
            sphere { <-1.25, -0.6, -0.6>,0.3 }
            sphere { <-1.25, -0.6, -0.6>,0.29 }
         }
         difference {
            sphere { <-1.25, -0.6,  0.6>,0.3 }
            sphere { <-1.25, -0.6,  0.6>,0.29 }
         }
         difference {
            sphere { <-1.25,    0,    0>,0.3 }
            sphere { <-1.25,    0,    0>,0.29 }
         }
         difference {
            sphere { <-1.25,  0.6, -0.6>,0.3 }
            sphere { <-1.25,  0.6, -0.6>,0.29 }
         }
         difference {
            sphere { <-1.25,  0.6,  0.6>,0.3 }
            sphere { <-1.25,  0.6,  0.6>,0.29 }
         }
         difference {
            sphere { <-0.45,  0.6, -1.25>,0.3 }
            sphere { <-0.45,  0.6, -1.25>,0.29 }
         }
         difference {
            sphere { <-0.45,    0, -1.25>,0.3 }
            sphere { <-0.45,    0, -1.25>,0.29 }
         }
         difference {
            sphere { <-0.45, -0.6, -1.25>,0.3 }
            sphere { <-0.45, -0.6, -1.25>,0.29 }
         }
         difference {
            sphere { < 0.45,  0.6, -1.25>,0.3 }
            sphere { < 0.45,  0.6, -1.25>,0.29 }
         }
         difference {
            sphere { < 0.45,    0, -1.25>,0.3 }
            sphere { < 0.45,    0, -1.25>,0.29 }
         }
         difference {
            sphere { < 0.45, -0.6, -1.25>,0.3 }
            sphere { < 0.45, -0.6, -1.25>,0.29 }
         }
      }
      texture { DICE_TEXT2 }
   }

}
