/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Eigenschaften;
import jafuffy.Erster;
import jafuffy.Oberflaeche;
import jafuffy.Spieler;
import jafuffy.Starter;
import jafuffy.Turnier;
import jafuffy.Variante;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class Absprache
extends JDialog
implements PropertyChangeListener,
ActionListener,
DocumentListener {
    private static final int DIALOGRAHMENABSTAND = 4;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private static final int SPALTEN = 8;
    private static final int ANZAHL = 20;
    private static final int TICKLABELS = 5;
    private static final int ORIENTIERUNGSTICKS = 5;
    private static final int FEINTICKS = 1;
    private final String[] namen = new String[4];
    private final Starter starter = new Starter();
    private final JTextField[] namenseingaben = new JTextField[4];
    private final JSlider anzahlschieberegler = new JSlider(0, 20);
    private final JComboBox<Variante> variantenauswahl = new JComboBox<Variante>(Variante.values());
    private final JComboBox<Turnier.Beginner> beginnmodusauswahl = new JComboBox<Turnier.Beginner>(Turnier.Beginner.values());
    private final JButton ok = new JButton("OK");
    private final JButton abbruch = new JButton("Abbruch");

    Absprache() {
        UIManager.addPropertyChangeListener(this);
        this.baueDialog();
        this.ueberwacheEingabe();
        this.aktiviereButtonleiste();
        this.setTitle("JaFuffy (Daten f\u00fcr neues Turnier)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.getRootPane().setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setModal(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.uebernehmeAnzahl();
        ArrayList<Spieler> spieler = this.uebernehmeSpieler();
        int startindex = this.bestimmeErsten(spieler);
        this.setVisible(false);
        this.starteTurnier(this.uebernehmeVariante(), spieler, startindex, this.uebernehmeBeginnmodus());
    }

    public void addActionListener(ActionListener listener) {
        this.starter.addActionListener(listener);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.ueberwacheEingabe();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.ueberwacheEingabe();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Beginnen")) {
            this.setLocationRelativeTo((JRootPane)event.getNewValue());
            this.setVisible(true);
        } else if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.ueberwacheEingabe();
    }

    @Override
    public void setVisible(boolean sichtbar) {
        this.ok.requestFocus();
        super.setVisible(sichtbar);
    }

    private void aktiviereButtonleiste() {
        this.abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Absprache.this.setVisible(false);
            }
        });
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
    }

    private JPanel anzahlauswahl() {
        JLabel label = new JLabel("Anzahl der Spiele im Turnier");
        label.setAlignmentX(0.5f);
        int anzahl = Integer.parseInt(Eigenschaften.GLOBAL.getProperty("Anzahl", "0"));
        this.anzahlschieberegler.setValue(anzahl);
        this.anzahlschieberegler.setMinorTickSpacing(1);
        this.anzahlschieberegler.setMajorTickSpacing(5);
        this.anzahlschieberegler.setPaintTicks(true);
        this.anzahlschieberegler.setPaintLabels(true);
        this.anzahlschieberegler.setSnapToTicks(true);
        Hashtable<Integer, JComponent> hashtable = this.anzahlschieberegler.createStandardLabels(5);
        hashtable.put(new Integer(0), new JLabel("beliebig"));
        this.anzahlschieberegler.setLabelTable(hashtable);
        JPanel anzahlfeld = new JPanel();
        anzahlfeld.setLayout(new BoxLayout(anzahlfeld, 1));
        anzahlfeld.add(label);
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(Box.createVerticalGlue());
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(this.anzahlschieberegler);
        return anzahlfeld;
    }

    private void baueBeginnmodusauswahl() {
        Turnier.Beginner beginnmodus;
        try {
            beginnmodus = Turnier.Beginner.valueOf(Eigenschaften.GLOBAL.getProperty("Beginnmodus", Turnier.Beginner.VERLIERER.name()));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            beginnmodus = Turnier.Beginner.VERLIERER;
        }
        this.beginnmodusauswahl.setAlignmentX(0.5f);
        this.beginnmodusauswahl.setSelectedIndex(beginnmodus.ordinal());
        this.beginnmodusauswahl.setToolTipText("Auswahl, welcher Mitspieler jedes neue Spiel beginnt");
    }

    private void baueDialog() {
        this.baueVariantenauswahl();
        this.baueBeginnmodusauswahl();
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 0));
        container.add(this.namenseingabefeld());
        container.add(Box.createHorizontalStrut(4));
        JPanel regelnfeld = new JPanel(new BorderLayout());
        regelnfeld.add((Component)this.regelnfeld(), "Center");
        container.add(regelnfeld);
        container.add(Box.createHorizontalStrut(4));
        JPanel buttonleiste = new JPanel(new BorderLayout());
        buttonleiste.add((Component)this.buttonleiste(), "Center");
        container.add(buttonleiste);
    }

    private void baueVariantenauswahl() {
        Variante variante;
        try {
            variante = Variante.valueOf(Eigenschaften.GLOBAL.getProperty("Variante", Variante.KLASSISCH.name()));
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            variante = Variante.KLASSISCH;
        }
        this.variantenauswahl.setAlignmentX(0.5f);
        this.variantenauswahl.setSelectedIndex(variante.ordinal());
        this.variantenauswahl.setToolTipText("Nach welchen Spielregeln soll gespielt werden?");
    }

    private int bestimmeErsten(ArrayList<Spieler> spieler) {
        Erster erster = new Erster(spieler);
        erster.setLocationRelativeTo(this);
        erster.setVisible(true);
        return erster.erster();
    }

    private JPanel buttonleiste() {
        JPanel buttonleiste = new JPanel(new GridLayout(0, 1, 0, 8));
        buttonleiste.setBorder(new EmptyBorder(12, 2, 8, 2));
        buttonleiste.add(this.ok);
        buttonleiste.add(this.abbruch);
        return buttonleiste;
    }

    private JPanel namenseingabefeld() {
        int i = 0;
        while (i < 4) {
            this.namen[i] = Eigenschaften.GLOBAL.getProperty("Spieler" + i, "");
            this.namenseingaben[i] = new JTextField(8);
            this.namenseingaben[i].setText(this.namen[i]);
            this.namenseingaben[i].getDocument().addDocumentListener(this);
            ++i;
        }
        JPanel namenfeld = new JPanel(new GridBagLayout());
        namenfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Namen"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(1, 0, 1, 0);
        int i2 = 0;
        while (i2 < 4) {
            constraints.gridy = i2;
            constraints.fill = 3;
            constraints.gridx = 0;
            constraints.weightx = 0.0;
            namenfeld.add((Component)new JLabel(String.valueOf(i2 + 1) + ". Spieler: ", 0), constraints);
            constraints.fill = 1;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            namenfeld.add((Component)this.namenseingaben[i2], constraints);
            ++i2;
        }
        namenfeld.add(new JLabel());
        JLabel label = new JLabel("Viel Spa\u00df!");
        label.setHorizontalAlignment(0);
        Font font = label.getFont().deriveFont(2);
        label.setFont(font);
        constraints.fill = 1;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 2.0;
        constraints.insets = new Insets(4, 0, 0, 0);
        namenfeld.add((Component)label, constraints);
        return namenfeld;
    }

    private JPanel regelnfeld() {
        JPanel regelnfeld = new JPanel();
        regelnfeld.setLayout(new BoxLayout(regelnfeld, 1));
        regelnfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Regeln"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        regelnfeld.add(this.beginnmodusauswahl);
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(this.variantenauswahl);
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(this.anzahlauswahl());
        regelnfeld.add(Box.createVerticalGlue());
        return regelnfeld;
    }

    private void starteTurnier(Variante variante, ArrayList<Spieler> spieler, int startindex, Turnier.Beginner beginnmodus) {
        try {
            this.starter.los(new Turnier(variante, spieler, startindex, beginnmodus, this.anzahlschieberegler.getValue()));
        }
        catch (IllegalArgumentException event) {
            event.printStackTrace();
        }
        catch (InstantiationException event) {
            event.printStackTrace();
        }
        catch (IllegalAccessException event) {
            event.printStackTrace();
        }
        catch (InvocationTargetException event) {
            event.printStackTrace();
        }
    }

    private void uebernehmeAnzahl() {
        Eigenschaften.GLOBAL.setProperty("Anzahl", Integer.toString(this.anzahlschieberegler.getValue()));
    }

    private Turnier.Beginner uebernehmeBeginnmodus() {
        Turnier.Beginner beginnmodus = Turnier.Beginner.values()[this.beginnmodusauswahl.getSelectedIndex()];
        Eigenschaften.GLOBAL.setProperty("Beginnmodus", beginnmodus.name());
        return beginnmodus;
    }

    private ArrayList<Spieler> uebernehmeSpieler() {
        int j = 0;
        ArrayList<Spieler> spieler = new ArrayList<Spieler>(4);
        int i = 0;
        while (i < 4) {
            if (!this.namen[i].equals("")) {
                spieler.add(new Spieler(this.namen[i]));
                Eigenschaften.GLOBAL.setProperty("Spieler" + j++, this.namen[i]);
            }
            ++i;
        }
        i = j;
        while (i < 4) {
            Eigenschaften.GLOBAL.setProperty("Spieler" + i, "");
            ++i;
        }
        return spieler;
    }

    private Variante uebernehmeVariante() {
        int var = this.variantenauswahl.getSelectedIndex();
        Variante variante = Variante.values()[var];
        Eigenschaften.GLOBAL.setProperty("Variante", variante.name());
        return variante;
    }

    private void ueberwacheEingabe() {
        int spieler = 0;
        int i = 0;
        while (i < 4) {
            this.namen[i] = this.namenseingaben[i].getText().trim();
            if (!this.namen[i].equals("")) {
                ++spieler;
            }
            ++i;
        }
        this.beginnmodusauswahl.setEnabled(spieler > 1);
        this.ok.setEnabled(spieler > 0);
    }
}

