/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.CEWuerfel;
import jafuffy.Geraeusch;
import jafuffy.Grafik;
import jafuffy.Spieler;
import jafuffy.Turnier;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Becher
extends JButton
implements ChangeListener {
    private static final ImageIcon[] BECHER = new ImageIcon[6];
    private static final Geraeusch[] WUERFELN;
    private static final Geraeusch SCHUETTELN;
    private static final int DELAY = 75;
    private static final String WERFEN = "<html>W\u00fcrfel im Becher werfen<br><small>Mausklick oder Taste \"w\"</small></html>";
    private static final String LEGEN = "Bitte W\u00fcrfel in Becher legen";
    private static final String SETZEN = "Bitte in der Tabelle setzen";
    private int gelegt = 0;
    private int geworfen = 0;

    static {
        int i = 0;
        while (i <= 5) {
            Becher.BECHER[i] = Grafik.icon("Becher" + i + ".gif");
            ++i;
        }
        WUERFELN = new Geraeusch[5];
        i = 0;
        while (i < 5) {
            Becher.WUERFELN[i] = new Geraeusch("Wuerfeln" + (i + 1) + ".wav");
            ++i;
        }
        SCHUETTELN = new Geraeusch("Schuetteln.wav");
    }

    Becher() {
        this.setFocusable(false);
        this.setAlignmentX(0.5f);
        this.setToolTipText(WERFEN);
        this.setEnabled(false);
        this.setIcon(BECHER[0]);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(87, 0), this);
        this.getActionMap().put(this, new AbstractAction(){
            private static final int KLICKZEIT = 200;

            @Override
            public void actionPerformed(ActionEvent ev) {
                JButton button = (JButton)ev.getSource();
                button.doClick(200);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEWuerfel.class)) {
            switch ((CEWuerfel)((Object)CEJaFuffy.ereignis(ce))) {
                case ANWAHL: {
                    ++this.gelegt;
                    this.aktualisiere();
                    break;
                }
                case ABWAHL: {
                    --this.gelegt;
                    this.aktualisiere();
                    break;
                }
                case WURF: {
                    ++this.geworfen;
                    break;
                }
            }
        } else if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    this.aktualisiere();
                }
                case GESETZT: {
                    SCHUETTELN.play(75);
                    break;
                }
                case WUERFELN: {
                    this.wuerfle();
                    break;
                }
                case GEWUERFELT: {
                    this.aktualisiere(((Turnier)ce.getSource()).aktiver());
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.gelegt = 0;
                    this.geworfen = 0;
                    break;
                }
            }
        }
    }

    private void aktualisiere() {
        this.setEnabled(this.gelegt > 0);
        this.setIcon(BECHER[this.gelegt]);
        this.setToolTipText(this.zustandsbeschreibung());
    }

    private void aktualisiere(Spieler aktiv) {
        this.setEnabled(false);
        this.setToolTipText(this.zustandsbeschreibung(aktiv));
    }

    private void wuerfle() {
        WUERFELN[this.geworfen - 1].play(75);
        this.geworfen = 0;
    }

    private String zustandsbeschreibung() {
        if (this.gelegt > 0) {
            return WERFEN;
        }
        return LEGEN;
    }

    private String zustandsbeschreibung(Spieler aktiv) {
        if (aktiv.rest() == 0) {
            return SETZEN;
        }
        return this.zustandsbeschreibung();
    }
}

