/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.BestenlisteModell;
import jafuffy.CEJaFuffy;
import jafuffy.CEStatistik;
import jafuffy.Grafik;
import jafuffy.Oberflaeche;
import jafuffy.Statistik;
import jafuffy.Variante;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Bestenliste
extends JDialog
implements PropertyChangeListener,
ChangeListener {
    private static final ImageIcon MEDAILLE = Grafik.icon("Goldwuerfel.png");
    private static final int ZWISCHENRAUM = 4;
    private final JLabel[] anzahl = new JLabel[Variante.values().length];
    private final JLabel[] durchschnitt = new JLabel[Variante.values().length];
    private final JLabel[] standardabweichung = new JLabel[Variante.values().length];
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final BestenlisteModell[] bestenlisteModelle;
    private final Statistik statistik;

    Bestenliste(Statistik statistik, int variante) {
        this.statistik = statistik;
        UIManager.addPropertyChangeListener(this);
        JPanel pane = new JPanel(new BorderLayout(8, 8));
        pane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.bestenlisteModelle = statistik.bestenlisteModelle();
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante var = varianteArray[n2];
            int i = var.ordinal();
            JPanel statistikfelder = new JPanel(new FlowLayout(1, 8, 4));
            this.anzahl[i] = new JLabel();
            statistikfelder.add(this.anzahl[i]);
            this.anzahl[i].setToolTipText("Anzahl aller bisherigen Spiele (" + var.spielregelname + ")");
            this.durchschnitt[i] = new JLabel();
            statistikfelder.add(this.durchschnitt[i]);
            this.durchschnitt[i].setToolTipText("Punktedurchschnitt aller bisherigen Spiele (" + var.spielregelname + ")");
            this.standardabweichung[i] = new JLabel();
            statistikfelder.add(this.standardabweichung[i]);
            this.standardabweichung[i].setToolTipText("Standardabweichung f\u00fcr bisherige Spiele (" + var.spielregelname + ")");
            JTable table = new JTable(this.bestenlisteModelle[i]);
            table.setIntercellSpacing(new Dimension(4, 0));
            table.getColumnModel().getColumn(Spalten.RANG.ordinal()).setPreferredWidth(this.spaltenbreite("Rang"));
            table.getColumnModel().getColumn(Spalten.NAME.ordinal()).setPreferredWidth(this.spaltenbreite("!Mitspieler!"));
            table.getColumnModel().getColumn(Spalten.PUNKTE.ordinal()).setPreferredWidth(this.spaltenbreite("Punkte"));
            table.getColumnModel().getColumn(Spalten.DATUM.ordinal()).setPreferredWidth(this.spaltenbreite("00.00.0000"));
            table.getColumnModel().getColumn(Spalten.KOMMENTAR.ordinal()).setMinWidth(this.spaltenbreite("Ein Spielerkommentar."));
            table.setRowSelectionAllowed(false);
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(new MatteBorder(MEDAILLE), new EtchedBorder(1)));
            scrollPane.setPreferredSize(new Dimension(16 * MEDAILLE.getIconWidth(), 8 * MEDAILLE.getIconWidth()));
            JPanel daten = new JPanel(new BorderLayout());
            daten.add((Component)statistikfelder, "North");
            daten.add((Component)scrollPane, "Center");
            daten.setBorder(new EmptyBorder(0, 4, 8, 4));
            this.tabbedPane.addTab(var.spielregelname, daten);
            ++n2;
        }
        this.tabbedPane.setSelectedIndex(variante);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bestenliste.this.setVisible(false);
            }
        });
        pane.add((Component)this.tabbedPane, "Center");
        pane.add((Component)ok, "South");
        this.belegeFelder();
        this.getRootPane().setDefaultButton(ok);
        this.setContentPane(pane);
        this.setTitle("JaFuffy (Liste der zehn besten Punktzahlen)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            switch ((CEStatistik)((Object)CEJaFuffy.ereignis(ce))) {
                case TURNIER_START: 
                case TURNIER_WEITER: {
                    this.tabbedPane.setSelectedIndex(this.statistik.variante());
                    break;
                }
                case SPIEL_ENDE: {
                    this.bestenlisteModelle[this.statistik.variante()].aktualisieren();
                    this.tabbedPane.setSelectedIndex(this.statistik.variante());
                    this.belegeFelder();
                    break;
                }
            }
        }
    }

    private void belegeFelder() {
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante var = varianteArray[n2];
            int i = var.ordinal();
            this.anzahl[i].setText("Anzahl: " + this.statistik.n(i));
            if (this.statistik.n(i) > 1) {
                this.durchschnitt[i].setText("Durchschnitt: " + NumberFormat.getInstance().format(Math.floor(this.statistik.durchschnitt(i) * 10.0 + 0.5) / 10.0));
                this.standardabweichung[i].setText("Standardabweichung: " + NumberFormat.getInstance().format(Math.floor(this.statistik.standardabweichung(i) * 10.0 + 0.5) / 10.0));
            } else {
                this.durchschnitt[i].setText("Durchschnitt: -");
                this.standardabweichung[i].setText("Standardabweichung: -");
            }
            ++n2;
        }
    }

    private int spaltenbreite(String titel) {
        FontMetrics metrik = this.getFontMetrics(this.getFont());
        int breite = metrik.stringWidth(titel);
        return breite;
    }

    static enum Spalten {
        RANG,
        NAME,
        PUNKTE,
        DATUM,
        KOMMENTAR;

    }
}

