/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Fenster;
import jafuffy.Signal;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JOptionPane;

class Update {
    private static final String DOWNLOAD = "http://jafuffy.3kelvin.de/download.html";
    private static final URL LATEST;
    private final Fenster fenster;
    private boolean mitteilen = false;

    static {
        URL latest = null;
        try {
            latest = new URL("http://jafuffy.3kelvin.de/jafuffy.mf");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        LATEST = latest;
    }

    Update(Fenster fenster) {
        this.fenster = fenster;
    }

    public void ueberpruefe() {
        String installiert = Package.getPackage("jafuffy").getImplementationVersion();
        String neueste = this.ermittleLetzteVersion();
        if (neueste != null) {
            if (installiert != null && neueste.compareTo(installiert) <= 0) {
                if (this.mitteilen) {
                    JOptionPane.showMessageDialog(this.fenster, "Keine neuere Version auf der JaFuffy-Homepage vorhanden,\nkeine Aktion notwendig.", "JaFuffy (Hinweis)", 1);
                }
            } else if (JOptionPane.showConfirmDialog(this.fenster, "Neuere Version gefunden auf der JaFuffy-Homepage,\nzur Downloadseite gehen?", "JaFuffy (Frage)", 0) == 0) {
                try {
                    Desktop.getDesktop().browse(new URI(DOWNLOAD));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String ermittleLetzteVersion() {
        String titel = new String();
        String version = null;
        try {
            Scanner in = new Scanner(new BufferedReader(new InputStreamReader(LATEST.openStream())));
            while (in.hasNext()) {
                String token = in.next();
                if (token.equals("Implementation-Version:")) {
                    version = in.nextLine().trim();
                    continue;
                }
                if (!token.equals("Implementation-Title:")) continue;
                titel = in.next();
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(this.fenster, "Kann keine Information von der JaFuffy-Homepage holen:\n" + e + "\n(Die Suche bei Programmstart kann im Men\u00fc \"Einstellungen\" unterbunden werden.)", "JaFuffy (Fehler)", 0);
            return null;
        }
        return titel.equals("JaFuffy") ? version : null;
    }

    void aktiviereMitteilung() {
        this.mitteilen = true;
    }
}

