/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Pfad;
import jafuffy.bedienung.Signal;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Willkommen
extends JDialog {
    private static final ImageIcon WILLKOMMEN1 = Grafik.icon("Willkommen1.gif");
    private static final String ID1 = "1";
    private static final ImageIcon WILLKOMMEN2 = Grafik.icon("Willkommen2.gif");
    private static final String ID2 = "2";
    private static final String INSTALLATION = "Installation.html";
    private static final URL HINWEISE = Ressource.LIESMICH.url("Installation.html");
    private static final Font BOLD18 = new Font("Dialog", 1, 18);

    public Willkommen(final Eigenschaften eigenschaften) {
        JEditorPane hilfe;
        JLabel titel = new JLabel("Willkommen zu JaFuffy!", 0);
        titel.setFont(BOLD18);
        final JPanel grafik = new JPanel(new CardLayout());
        grafik.add((Component)new JLabel(WILLKOMMEN1), ID1);
        grafik.add((Component)new JLabel(WILLKOMMEN2), ID2);
        final Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)grafik.getLayout()).next(grafik);
            }
        });
        JTextArea beschreibung = new JTextArea("JaFuffy ist ein W\u00fcrfelspiel mit drei Spielregelvarianten, \u00e4hnlich zu Kniffel, Yahtzee oder Fuffy. Spiele k\u00f6nnen zu Turnieren zusammengefasst, gespeichert und geladen werden. Die besten Punktzahlen werden in Listen eingetragen. Bis zu vier Mitspieler sind m\u00f6glich.", 3, 45);
        beschreibung.setLineWrap(true);
        beschreibung.setWrapStyleWord(true);
        beschreibung.setEditable(false);
        beschreibung.setOpaque(false);
        beschreibung.setBorder(BorderFactory.createTitledBorder(null, "Kurzbeschreibung", 1, 1));
        JCheckBox nachschauen = new JCheckBox();
        nachschauen.setSelected(eigenschaften.aktiv("Nachschauen"));
        nachschauen.setBorderPainted(true);
        nachschauen.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(2, 4, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), new EmptyBorder(0, 8, 0, 8))));
        nachschauen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                eigenschaften.wechsle("Nachschauen");
            }
        });
        JTextArea suchverhalten = new JTextArea("Automatisch bei jedem Programmstart nach neuerer Version auf JaFuffys Homepage suchen. Das Verhalten kann nachtr\u00e4glich im Men\u00fcpunkt \"Einstellungen - Nachschauen\" festgelegt werden. Der Men\u00fcpunkt \"Hilfe - Aktualisieren...\" st\u00f6\u00dft die Suche explizit an.", 3, 45);
        suchverhalten.setLineWrap(true);
        suchverhalten.setWrapStyleWord(true);
        suchverhalten.setEditable(false);
        suchverhalten.setOpaque(false);
        JPanel aktualiserungsfeld = new JPanel(new BorderLayout());
        aktualiserungsfeld.setBorder(BorderFactory.createTitledBorder(null, "Auf Homepage nachschauen", 1, 1));
        aktualiserungsfeld.add((Component)nachschauen, "East");
        aktualiserungsfeld.add((Component)suchverhalten, "Center");
        try {
            hilfe = new JEditorPane(HINWEISE);
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(null, "(De)Installationshinweise \"Installation.html\" k\u00f6nnen nicht geladen werden!", "JaFuffy (Warnung)", 2);
            hilfe = new JEditorPane("text", "(De)Installationshinweise \"Installation.html\" k\u00f6nnen nicht geladen werden!");
        }
        hilfe.setEditable(false);
        hilfe.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(he.getURL().toURI());
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                    }
                }
            }
        });
        JScrollPane hilfescroll = new JScrollPane(hilfe);
        JPanel hilfefeld = new JPanel(new BorderLayout());
        hilfefeld.setPreferredSize(new Dimension(400, 275));
        hilfefeld.setBorder(BorderFactory.createTitledBorder(null, "Hinweise zur (De)Installation", 1, 1));
        hilfefeld.add((Component)grafik, "West");
        hilfefeld.add((Component)hilfescroll, "Center");
        JPanel leiste = new JPanel(new GridLayout(1, 2, 4, 4));
        JButton abbruch = new JButton("Abbruch");
        abbruch.setToolTipText("Programm beenden");
        abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JButton weiter = new JButton("Weiter");
        weiter.setToolTipText("Einstellungspfad w\u00e4hlen und Programm beginnen");
        weiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Willkommen.this.setVisible(false);
                timer.stop();
            }
        });
        weiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Pfad(eigenschaften, Willkommen.this);
                Willkommen.this.setVisible(false);
                timer.stop();
            }
        });
        leiste.add(weiter);
        leiste.add(abbruch);
        JPanel texte = new JPanel(new BorderLayout(8, 8));
        texte.add((Component)beschreibung, "North");
        texte.add((Component)hilfefeld, "Center");
        texte.add((Component)aktualiserungsfeld, "South");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        titel.setAlignmentX(0.5f);
        panel.add(titel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(texte);
        panel.add(Box.createVerticalStrut(8));
        panel.add(leiste);
        this.setDefaultCloseOperation(0);
        this.setTitle("JaFuffy (Er\u00f6ffnungsmeldung)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
        this.setContentPane(panel);
        this.getRootPane().setDefaultButton(weiter);
        this.pack();
        this.setLocationRelativeTo(null);
        timer.start();
        this.setVisible(true);
    }
}

