/******************************************************************************
 ** $Id: Report.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEStatistik;
import jafuffy.logik.Statistik;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

/**
 * Report ber Punktzahlen (Anzeige).
 */
@SuppressWarnings("serial")
public class Report extends JDialog implements PropertyChangeListener, ChangeListener {

    // Farben & Rahmen fr die Legende
    static final Color[] FARBEN =
            { Color.red, Color.green.darker(), Color.blue, Color.magenta };
    private static final Border RAHMEN = BorderFactory.createCompoundBorder(
            BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());

    // enthlt Diagramme
    private final JPanel pane;
    // Statistikdaten + Panels (Balkendiagramme)
    private final Statistik statistik;
    private final JScrollPane scrollstand;
    private final BalkenStand stand;
    private final JScrollPane scrollverlauf;
    private final BalkenVerlauf verlauf;
    // Legende
    private final JPanel legende = new JPanel(new GridLayout(0, 1, 8, 8));

    /**
     * Konstruktor.
     *
     * @param statistik
     *            statistische Daten
     */
    public Report(Statistik statistik) {

        this.statistik = statistik;
        UIManager.addPropertyChangeListener(this);

        // Balkendiagrammanzeigen (Stand, Verlauf)
        stand = new BalkenStand(statistik);
        verlauf = new BalkenVerlauf(statistik);
        // Buttonleiste
        JButton button = new JButton("Legende");
        button.setToolTipText("Zuordnung Farben/Spieler");
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Report.this, legende, "JaFuffy (Legende)",
                        JOptionPane.INFORMATION_MESSAGE);
            }
        });
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 4, 4));
        leiste.setBorder(BorderFactory.createEmptyBorder(4, 2, 0, 2));
        leiste.add(button);
        leiste.add(ok);
        // Zusammenbau der Felder zur grafischen Darstellung
        pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        scrollstand = new JScrollPane(stand);
        scrollstand.setBorder(BorderFactory.createTitledBorder(RAHMEN, "(Zwischen)Stand",
                TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.ABOVE_TOP));
        pane.add(scrollstand, BorderLayout.NORTH);
        scrollverlauf = new JScrollPane(verlauf);
        scrollverlauf.setBorder(BorderFactory.createTitledBorder(RAHMEN, "Turnierverlauf",
                TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.ABOVE_TOP));
        // Dragging und Auto-Scroll
        MouseInputListener mouseInputListener = new MouseInputAdapter() {
            private int x;
            private int y;

            @Override
            public void mousePressed(MouseEvent e) {
                x = e.getX();
                y = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r;
                r = scrollverlauf.getViewport().getViewRect();
                r.translate(x - e.getX(), y - e.getY());
                ((JPanel) e.getSource()).scrollRectToVisible(r);
            }
        };
        verlauf.addMouseMotionListener(mouseInputListener);
        verlauf.addMouseListener(mouseInputListener);
        pane.add(scrollverlauf, BorderLayout.CENTER);
        // Abschluss Aufbau
        pane.add(leiste, BorderLayout.SOUTH);
        setContentPane(pane);
        getRootPane().setDefaultButton(button);
        setTitle("JaFuffy (Report)");
        setIconImages(Oberflaeche.LOGOS);
        pack();

    }

    /**
     * Realisiert Vernderungen des Look&Feel.
     *
     * @param evt
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    /**
     * Modelldaten habe sich gendert.
     *
     * @param ce
     */
    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            switch (CEJaFuffy.<CEStatistik> ereignis(ce)) {
            case TURNIER_START:
            case TURNIER_WEITER:
                JLabel name;
                legende.removeAll();
                for (int i = 0; i < statistik.spieler().size(); i++) {
                    name =
                            new JLabel(statistik.spieler().get(i).toString(),
                                    SwingConstants.CENTER);
                    legende.add(name);
                    name.setOpaque(true);
                    name.setForeground(FARBEN[i]);
                    name.setBackground(Color.white);
                    name.setBorder(BorderFactory.createCompoundBorder(
                            BorderFactory.createLineBorder(FARBEN[i], 2),
                            BorderFactory.createEmptyBorder(2, 4, 2, 4)));
                }
                stand.neuesTurnier();
                verlauf.neuesTurnier();
                pane.validate();
                break;
            case SPIEL_ENDE:
                verlauf.spielende();
                break;
            case STAND:
                stand.neuerStand();
                verlauf.neuerStand();
                break;
            default:
                break;
            }
            pane.repaint();
        }
    }

    /**
     * Beim Sichtbarmachen Verlauf explizit bercksichtigen.
     *
     * @param sichtbar
     */
    @Override
    public void setVisible(boolean sichtbar) {
        super.setVisible(sichtbar);
        verlauf.setVisible(sichtbar);
    }

}
