/******************************************************************************
 ** $Id: AuswertungImHieb.java 741 2015-05-26 20:51:29Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

/**
 * Im-Hieb-Auswertung. Ermittelt die Punktzahl eines Spielers zum vorliegenden Wurf.
 * Im-Hieb-Erkennung.
 */
public class AuswertungImHieb extends AuswertungKlassisch {

    private static final long serialVersionUID = 6730182688848850948L;

    // einige Punktzahlen, Mittelwert und Standabweichung (Schtzwerte)
    private static final int IM_HIEB_MIN = 5;
    private static final int IM_HIEB_MAX = 30;
    private static final int MITTELWERT = 235;
    private static final int ABWEICHUNG = 45;

    /** Regelname. */
    static final String REGEL = "Im-Hieb-Regeln";

    /** Soll Nachricht "Im Hieb!" in Tabelle erscheinen? */
    private boolean imHiebNachricht = false;
    /** In welcher Zeile erscheint "Im Hieb!"? */
    private Tabzeile imHiebEintrag;

    /**
     * Konstruktor.
     *
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     */
    public AuswertungImHieb(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    /**
     * @return Regelname
     */
    @Override
    public String toString() {
        return REGEL;
    }

    /** Im-Hieb-Nachricht deaktivieren. */
    public void imHiebNachrichtDeaktiv() {
        imHiebNachricht = false;
    }

    /**
     * Im-Hieb-Nachricht aktivieren.
     *
     * @param imHiebEintrag
     *            fr diese Zeile
     */
    public void imHiebNachrichtAktiv(Tabzeile imHiebEintrag) {
        this.imHiebEintrag = imHiebEintrag;
        imHiebNachricht = true;
    }

    /**
     * Spezielles Feld im Hieb?
     *
     * @param eintrag
     *            Nummer des Eintrags auf dem Punktezettel
     */
    public boolean imHieb(Tabzeile eintrag) {
        return eintrag.unten() && eintrag != Tabzeile.CHANCE && spieler.einmalig()
                && super.wert(eintrag) > 0;
    }

    /**
     * @return geschtzte mittlere Punktzahl pro Spiel
     */
    @Override
    int mittelwert() {
        return MITTELWERT;
    }

    /**
     * @return geschtzte Abweichung von mittlerer Punktzahl pro Spiel
     */
    @Override
    int abweichung() {
        return ABWEICHUNG;
    }

    /**
     * @param eintrag
     *            Nummer des Eintrags auf dem Punktezettel
     * @return erwrfelte Punkte fr das Eintragsfeld
     */
    @Override
    public int wert(Tabzeile eintrag) {
        if (imHieb(eintrag)) {
            return super.wert(eintrag)
                    + (eintrag == Tabzeile.JAFUFFY ? IM_HIEB_MAX : IM_HIEB_MIN);
        } else {
            return super.wert(eintrag);
        }
    }

    /**
     * @param eintrag
     *            Zeilennummer des Eintrags
     * @return Texteintrag fr Tabelle ("Im Hieb!"-Nachricht)
     */
    @Override
    public String text(Tabzeile eintrag) {
        return imHiebNachricht && eintrag == imHiebEintrag ? "Im Hieb!" : null;
    }

}
