/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.path.PathInputPanel;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PathInputBase {
    private static InstallData installData;
    private static final transient Logger logger;

    public static void setInstallData(InstallData installData) {
        PathInputBase.installData = installData;
    }

    public static boolean isWritable(String path) {
        return PathInputBase.isWritable(new File(path));
    }

    public static boolean isWritable(File path) {
        boolean result = false;
        File existParent = IoHelper.existingParent(path);
        if (existParent != null) {
            if (installData.getPlatform().isA(Platforms.WINDOWS)) {
                try {
                    File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                    result = true;
                    if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.toString(), e);
                }
            } else {
                result = existParent.canWrite();
            }
        }
        return result;
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return "";
        }
        if (path.startsWith("~") && installData.getPlatform().isA(Platform.Name.UNIX)) {
            String home = System.getProperty("user.home");
            path = home + path.substring(1);
        }
        String normalizedPath = new File(path).getAbsolutePath();
        return normalizedPath;
    }

    static {
        logger = Logger.getLogger(PathInputPanel.class.getName());
    }
}

