/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.os.SystemErrorException;
import com.izforge.izpack.util.os.WinSetupQueueCallbackInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WinSetupDefaultCallbackHandler
implements WinSetupQueueCallbackInterface {
    private List<SystemErrorException> exceptions;

    @Override
    public int handleNeedMedia(String tagfile, String description, String sourcePath, String sourceFile) {
        File file = new File(sourcePath, sourceFile);
        if (file.exists() && file.canRead()) {
            return 1;
        }
        this.addException("Source file " + file.getPath() + " not found, aborting.");
        return 0;
    }

    @Override
    public int handleCopyError(String source, String target, int errCode, String errMsg) {
        this.addException(errCode, "Aborting copying " + source + " -> " + target + ": " + errMsg);
        return 0;
    }

    @Override
    public int handleDeleteError(String target, int errCode, String errMsg) {
        this.addException(errCode, "Skipping deleting " + target + ": " + errMsg);
        return 2;
    }

    @Override
    public int handleRenameError(String source, String target, int errCode, String errMsg) {
        this.addException(errCode, "Aborting renaming " + source + " -> " + target + ": " + errMsg);
        return 0;
    }

    public List<SystemErrorException> getExceptions() {
        return this.exceptions;
    }

    private void addException(String errMsg) {
        this.addException(0, errMsg);
    }

    private void addException(int errCode, String errMsg) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<SystemErrorException>();
        }
        this.exceptions.add(new SystemErrorException(errCode, errMsg));
    }
}

