/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import java.io.Serializable;
import java.util.HashMap;

public class Spieler
implements Comparable<Spieler>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5170511106942700515L;
    public static final int SPIELER = 4;
    static final int GRENZE = 63;
    static final int BONUS = 35;
    private final String name;
    private final HashMap<Tabzeile, Integer> punktzahlen = new HashMap(Tabzeile.ANZAHL);
    private final HashMap<Tabzeile, Boolean> setzbar = new HashMap(Tabzeile.ANZAHL);
    private int rest;
    private boolean gewuerfelt;
    private boolean einmalig;
    private transient Punkte.Meldung meldung;

    public Spieler(String name) {
        this.name = name;
        this.vorbereiten();
    }

    void beobachten(Punkte.Meldung meldung) {
        this.meldung = meldung;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Spieler spieler) {
        if (this.endsumme() < spieler.endsumme()) {
            return -1;
        }
        if (this.endsumme() > spieler.endsumme()) {
            return 1;
        }
        return 0;
    }

    void vorbereiten() {
        Tabzeile[] tabzeileArray = Tabzeile.values();
        int n = tabzeileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            this.punktzahl(z, 0);
            switch (z) {
                case GESAMT: 
                case BONUS: 
                case OSUMME: 
                case USUMME: 
                case ESUMME: {
                    this.setzbarkeit(z, false);
                    break;
                }
                default: {
                    this.setzbarkeit(z, true);
                }
            }
            ++n2;
        }
        this.warten();
    }

    void aktivieren() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = 3;
        this.melden();
    }

    void reaktivieren() {
        this.melden();
    }

    Spieler kopie() {
        Spieler spieler = new Spieler(this.name);
        spieler.punktzahlen.putAll(this.punktzahlen);
        spieler.setzbar.putAll(this.setzbar);
        spieler.rest = 0;
        spieler.gewuerfelt = true;
        spieler.einmalig = this.einmalig;
        spieler.meldung = this.meldung;
        return spieler;
    }

    void wuerfeln() {
        this.gewuerfelt = true;
        this.einmalig = this.rest == 3;
        --this.rest;
        this.melden();
    }

    public void eintragen(Tabzeile eintrag, int wert) {
        this.setzen(eintrag, wert, false);
    }

    void setzen(Tabzeile eintrag, int wert) {
        this.setzen(eintrag, wert, true);
    }

    void warten() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = 0;
        this.melden();
    }

    public int rest() {
        return this.rest;
    }

    public boolean gewuerfelt() {
        return this.gewuerfelt;
    }

    boolean einmalig() {
        return this.einmalig;
    }

    public int punkte(Tabzeile eintrag) {
        return this.punktzahl(eintrag);
    }

    int gesamt() {
        return this.punktzahl(Tabzeile.GESAMT);
    }

    public int endsumme() {
        return this.punktzahl(Tabzeile.ESUMME);
    }

    void setzbarkeit(Tabzeile eintrag, boolean aktiviert) {
        this.setzbar.put(eintrag, aktiviert);
    }

    boolean setzbar(Tabzeile eintrag) {
        return this.setzbar.get((Object)eintrag);
    }

    private void setzen(Tabzeile eintrag, int wert, boolean weiter) {
        Tabzeile z;
        int oben = 0;
        int bonus = 0;
        int unten = 0;
        this.punktzahl(eintrag, wert);
        this.setzbarkeit(eintrag, false);
        Tabzeile[] tabzeileArray = Tabzeile.OBEN;
        int n = Tabzeile.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            z = tabzeileArray[n2];
            oben += this.punktzahl(z);
            ++n2;
        }
        this.punktzahl(Tabzeile.GESAMT, oben);
        if (this.punktzahl(Tabzeile.GESAMT) >= 63) {
            bonus = 35;
        }
        this.punktzahl(Tabzeile.BONUS, bonus);
        this.punktzahl(Tabzeile.OSUMME, oben + bonus);
        tabzeileArray = Tabzeile.UNTEN;
        n = Tabzeile.UNTEN.length;
        n2 = 0;
        while (n2 < n) {
            z = tabzeileArray[n2];
            unten += this.punktzahl(z);
            ++n2;
        }
        this.punktzahl(Tabzeile.USUMME, unten);
        this.punktzahl(Tabzeile.ESUMME, oben + bonus + unten);
        if (weiter) {
            this.warten();
        } else {
            this.reaktivieren();
        }
    }

    private void punktzahl(Tabzeile eintrag, int wert) {
        this.punktzahlen.put(eintrag, wert);
    }

    private int punktzahl(Tabzeile eintrag) {
        return this.punktzahlen.get((Object)eintrag);
    }

    private void melden() {
        if (this.meldung != null) {
            this.meldung.mitteilen();
        }
    }
}

