/******************************************************************************
 ** $Id: Hilfe.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Ressource;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Stack;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/** Hilfe (HTML-Minibrowser). */
@SuppressWarnings("serial")
class Hilfe extends JDialog implements PropertyChangeListener, HyperlinkListener {

    /** Anfngliche Breite des Hilfefensters. */
    private static final int BREITE = 600;
    /** Anfngliche Hhe des Hilfefensters. */
    private static final int HOEHE = 400;
    /** Einstieg in Hilfeseiten (Hilfeindex). */
    private static final String INDEX = "index.html";
    /** URL des Hilfeindex. */
    private static final URL STARTSEITE = Ressource.ANLEITUNG.url(INDEX);

    /** Startseite, initialisiert mit aktueller Seite. */
    private URL seite = STARTSEITE;
    /** Darstellungsobjekt fr HTML-Hilfetext. */
    private final JEditorPane browser = new JEditorPane();
    /** Seitenverlauf. */
    private final Stack<URL> history = new Stack<URL>();

    /** Hilfefeld. */
    private final JPanel hilfe = new JPanel(new BorderLayout(8, 8));
    /** Leiste mit Kontrollen. */
    private final JPanel kontrollen = new JPanel(new GridLayout(1, 0, 4, 2));
    /** Inhalt-Button (Hilfeindex). */
    private final JButton inhalt = new JButton("Zum Hilfebeginn");
    /** Zurck-Button. */
    private final JButton zurueck = new JButton("Schritt zurck");
    /** Beenden-Button. */
    private final JButton beenden = new JButton("Hilfe beenden");

    /**
     * Konstruktor.
     *
     * @throws Exception
     *             Problem bei Erstellung der Hilfe.
     */
    Hilfe() throws Exception {

        setTitle("JaFuffy (Hilfe)");
        setIconImages(Oberflaeche.LOGOS);

        UIManager.addPropertyChangeListener(this);

        // erste Seite in Browser laden
        browser.setPage(seite);

        // Browser-Elemente
        kontrollen.add(inhalt);
        inhalt.setEnabled(false);
        kontrollen.add(zurueck);
        zurueck.setEnabled(false);
        kontrollen.add(beenden);

        // Hilfetext
        browser.setEditable(false);
        browser.addHyperlinkListener(this);

        // Zurck zum Anfang
        inhalt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    history.push(seite);
                    seite = STARTSEITE;
                    browser.setPage(seite);
                    inhalt.setEnabled(false);
                } catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });

        // Schritt zurck
        zurueck.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    seite = history.pop();
                    browser.setPage(seite);
                } catch (Exception ee) {
                    ee.printStackTrace();
                    Signal.WARNUNG.play();
                    JOptionPane.showMessageDialog(Hilfe.this, "Hilfe-Datei nicht gefunden!",
                            "JaFuffy (Warnung)", JOptionPane.WARNING_MESSAGE);
                }
                zurueck.setEnabled(!history.empty());
                inhalt.setEnabled(seite != STARTSEITE);
            }
        });

        // Hilfe beenden
        beenden.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });

        // Hilfefenster aufbauen
        hilfe.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane scrollPane = new JScrollPane(browser);
        scrollPane.setPreferredSize(new Dimension(BREITE, HOEHE));
        hilfe.add(scrollPane, BorderLayout.CENTER);
        hilfe.add(kontrollen, BorderLayout.SOUTH);
        getRootPane().setDefaultButton(beenden);
        setContentPane(hilfe);
        pack();
        beenden.requestFocus();

    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                history.push(seite);
                seite = he.getURL();
                browser.setPage(seite);
                zurueck.setEnabled(true);
                inhalt.setEnabled(seite != STARTSEITE);
            } catch (Exception e) {
                e.printStackTrace();
                Signal.WARNUNG.play();
                JOptionPane
                        .showMessageDialog(
                                Hilfe.this,
                                "Kann die folgende Seite nicht ffnen:\n"
                                        + seite.toString()
                                        + "\nGrund:\n"
                                        + e.toString()
                                        + "\n\nHinweis:\n"
                                        + "JaFuffy darf als Applet nicht auf externe Seiten zugreifen.",
                                "JaFuffy (Warnung)", JOptionPane.WARNING_MESSAGE);
            }
        }
    }

    /**
     * Realisiert Vernderungen des Look&Feel.
     *
     * @param event
     *            nderungsereignis.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

}
