/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.BalkenStand;
import jafuffy.bedienung.BalkenVerlauf;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEStatistik;
import jafuffy.logik.Statistik;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class Report
extends JDialog
implements PropertyChangeListener,
ChangeListener {
    static final Color[] FARBEN = new Color[]{Color.red, Color.green.darker(), Color.blue, Color.magenta};
    private static final Border RAHMEN = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
    private final JPanel pane;
    private final Statistik statistik;
    private final JScrollPane scrollstand;
    private final BalkenStand stand;
    private final JScrollPane scrollverlauf;
    private final BalkenVerlauf verlauf;
    private final JPanel legende = new JPanel(new GridLayout(0, 1, 8, 8));

    public Report(Statistik statistik) {
        this.statistik = statistik;
        UIManager.addPropertyChangeListener(this);
        this.stand = new BalkenStand(statistik);
        this.verlauf = new BalkenVerlauf(statistik);
        JButton button = new JButton("Legende");
        button.setToolTipText("Zuordnung Farben/Spieler");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Report.this, Report.this.legende, "JaFuffy (Legende)", 1);
            }
        });
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Report.this.setVisible(false);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 4, 4));
        leiste.setBorder(BorderFactory.createEmptyBorder(4, 2, 0, 2));
        leiste.add(button);
        leiste.add(ok);
        this.pane = new JPanel(new BorderLayout());
        this.pane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.scrollstand = new JScrollPane(this.stand);
        this.scrollstand.setBorder(BorderFactory.createTitledBorder(RAHMEN, "(Zwischen)Stand", 0, 1));
        this.pane.add((Component)this.scrollstand, "North");
        this.scrollverlauf = new JScrollPane(this.verlauf);
        this.scrollverlauf.setBorder(BorderFactory.createTitledBorder(RAHMEN, "Turnierverlauf", 0, 1));
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){
            private int x;
            private int y;

            @Override
            public void mousePressed(MouseEvent e) {
                this.x = e.getX();
                this.y = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Rectangle r = Report.this.scrollverlauf.getViewport().getViewRect();
                r.translate(this.x - e.getX(), this.y - e.getY());
                ((JPanel)e.getSource()).scrollRectToVisible(r);
            }
        };
        this.verlauf.addMouseMotionListener(mouseInputListener);
        this.verlauf.addMouseListener(mouseInputListener);
        this.pane.add((Component)this.scrollverlauf, "Center");
        this.pane.add((Component)leiste, "South");
        this.setContentPane(this.pane);
        this.getRootPane().setDefaultButton(button);
        this.setTitle("JaFuffy (Report)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEStatistik)((Object)cej.ereignis())) {
                case TURNIER_START: 
                case TURNIER_WEITER: {
                    this.legende.removeAll();
                    int i = 0;
                    while (i < this.statistik.spieler().size()) {
                        JLabel name = new JLabel(this.statistik.spieler().get(i).toString(), 0);
                        this.legende.add(name);
                        name.setOpaque(true);
                        name.setForeground(FARBEN[i]);
                        name.setBackground(Color.white);
                        name.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(FARBEN[i], 2), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
                        ++i;
                    }
                    this.stand.neuesTurnier();
                    this.verlauf.neuesTurnier();
                    this.pane.validate();
                    break;
                }
                case SPIEL_ENDE: {
                    this.verlauf.spielende();
                    break;
                }
                case STAND: {
                    this.stand.neuerStand();
                    this.verlauf.neuerStand();
                    break;
                }
            }
            this.pane.repaint();
        }
    }

    @Override
    public void setVisible(boolean sichtbar) {
        super.setVisible(sichtbar);
        this.verlauf.setVisible(sichtbar);
    }
}

