/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.logik.Aenderungen;
import jafuffy.logik.Analyse;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;

public abstract class Auswertung
extends Aenderungen<CEAblauf> {
    private static final long serialVersionUID = -7315969783651586016L;
    protected final Wuerfel[] wuerfel;
    protected final Analyse analyse;
    protected boolean tipps;
    protected Spieler aktiver;

    Auswertung(Wuerfel[] wuerfel) {
        this.wuerfel = wuerfel;
        this.analyse = new Analyse(wuerfel);
    }

    public Tabzeile bester() {
        return this.analyse.bester();
    }

    public boolean bester(Tabzeile eintrag) {
        return this.analyse.bester() == eintrag;
    }

    public String spicker(Tabzeile eintrag) {
        String text;
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && this.aktiver.setzbar(eintrag) && eintrag.alle()) {
            int punkte = this.wert(eintrag);
            text = String.valueOf(new Integer(punkte).toString()) + (punkte != 1 ? " Punkte" : " Punkt");
            if (this.tipps()) {
                text = "<html><p>" + text + "</p>" + "<p><small><i>Siehe auch Kontextmen\u00fc!</i></small></p>" + "<p><small><i>Beachte Men\u00fc \"Extras\".</i></small></p>" + "</html>";
            }
        } else {
            text = null;
        }
        return text;
    }

    public abstract String text(Tabzeile var1);

    public boolean tipps() {
        return this.tipps;
    }

    public abstract String toString();

    public boolean vorgeschlagen(Tabzeile eintrag) {
        return this.analyse.vorgeschlagen(eintrag);
    }

    public void vorschlagen(Tabzeile eintrag) {
        int w = 0;
        while (w < 5) {
            boolean erneut = this.analyse.erneut(eintrag, w);
            this.wuerfel[w].setzeVorschlag(erneut);
            ++w;
        }
        this.fireStateChanged(CEAblauf.VORGESCHLAGEN);
    }

    public abstract int wert(Tabzeile var1);

    public float wichtung(Tabzeile eintrag) {
        return this.analyse.wichtung(eintrag);
    }

    abstract int abweichung();

    void gewuerfelt(Spieler spieler) {
        this.aktiver = spieler;
        this.tipps = false;
        this.analyse.errechne();
    }

    abstract int mittelwert();

    void tipps(boolean tipps) {
        if (tipps) {
            if (!this.tipps) {
                this.analyse.prognostiziere(this.aktiver);
                this.tipps = true;
            }
        } else {
            this.tipps = false;
        }
    }

    void vorschlagen() {
        this.tipps(true);
        this.vorschlagen(this.bester());
    }
}

