/******************************************************************************
 ** $Id: Lizenzierung.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Ressource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

/** Lizenzhinweise und GPL-Textlaut. */
@SuppressWarnings("serial")
class Lizenzierung extends JDialog implements PropertyChangeListener {

    /** Animiertes Icon. */
    private static final ImageIcon LIZENZ = Grafik.icon("Lizenzierung.gif");
    /** Name GPL-Lizenz-Datei (englisch). */
    private static final String GPL = "GPL.html";
    /** Name GPL-Lizenz-Datei (deutsch). */
    private static final String GPL_DE = "GPLde.html";
    /** URL der GPL-Lizenz-Datei. */
    private static final URL GPL_URL = Ressource.LIESMICH.url(GPL);
    /** URL der deutschen GPL-Lizenz-Datei. */
    private static final URL GPL_DE_URL = Ressource.LIESMICH.url(GPL_DE);
    /** Enstehungsseite aus der Anleitung. */
    private static final URL ENTSTEHUNG_URL = Ressource.ANLEITUNG.url("Entstehung.html");
    /** Font fr ergnzende Hinweise. */
    private static final Font ERGAENZUNGSFONT = new Font("Dialog", Font.PLAIN, 10);

    class VerweisGpl implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(GPL_DE_URL.toURI());
            } catch (Exception ex) {
                System.out.println(ex);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            return;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            return;
        }
    }

    class VerweisEntstehung implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(ENTSTEHUNG_URL.toURI());
            } catch (Exception ex) {
                System.out.println(ex);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            return;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            return;
        }
    }

    /**
     * Konstruktor.
     */
    Lizenzierung() {

        JEditorPane gpl;
        JScrollPane gplfeld;

        // Initialisierung
        UIManager.addPropertyChangeListener(this);
        setModal(true);
        setTitle("JaFuffy (Information)");
        setIconImages(Oberflaeche.LOGOS);
        JPanel feld = new JPanel();
        feld.setLayout(new BoxLayout(feld, BoxLayout.Y_AXIS));
        feld.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));

        // Eintrge hinzufgen
        JLabel label;
        feld.add(label =
                new JLabel(
                        "JaFuffy ist freie Software und unterliegt der GNU General Public License."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(label =
                new JLabel("Jeglicher Weiterverkauf ist untersagt, "
                        + "die kostenlose Weitergabe ist ausdrcklich erwnscht."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(label =
                new JLabel("Kommentare, Fehler oder Erweiterungswnsche per E-Mail bitte an "
                        + "<jafuffy@3kelvin.de>."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(Box.createVerticalStrut(8));
        feld.add(label =
                new JLabel("(C) Wolfgang Hauck; "
                        + "Anleitung basiert auf Entwurf von Christian Hauck"));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(Box.createVerticalStrut(12));
        feld.add(label =
                new JLabel("Nheres ber Drittkomponenten und eingesetzte Hilfsmittel:"));
        label.setFont(ERGAENZUNGSFONT);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(label = new JLabel(ENTSTEHUNG_URL.toString()));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        label.setFont(ERGAENZUNGSFONT);
        label.setForeground(Color.BLUE);
        label.addMouseListener(new VerweisEntstehung());
        feld.add(Box.createVerticalStrut(12));
        try {
            gpl = new JEditorPane(GPL_URL);
            gpl.setToolTipText("GPL im Original-Wortlaut (Kleingedrucktes :)");
        } catch (IOException e) {
            e.printStackTrace();
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(this, "Die Lizenzdatei \"" + GPL
                    + "\" kann nicht geladen werden!\n"
                    + "Ein vollstndiges Paket muss diese Datei enthalten!\n",
                    "JaFuffy (Warnung)", JOptionPane.WARNING_MESSAGE);
            gpl =
                    new JEditorPane("text", "Die Lizenzdatei \"" + GPL
                            + "\" kann nicht geladen werden!\n"
                            + "Eine vollstndige Distribution muss diese Datei enthalten!");
        }
        gpl.setEditable(false);
        gplfeld = new JScrollPane(gpl);
        gplfeld.setPreferredSize(new Dimension(520, 250));
        gplfeld.setBorder(BorderFactory.createTitledBorder(null, "GNU General Public License:",
                TitledBorder.LEFT, TitledBorder.ABOVE_TOP));
        gplfeld.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(gplfeld);
        feld.add(Box.createVerticalStrut(4));
        feld.add(label = new JLabel("Deutsch unter " + GPL_DE_URL));
        label.setFont(ERGAENZUNGSFONT);
        label.setForeground(Color.BLUE);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        label.addMouseListener(new VerweisGpl());
        feld.add(Box.createVerticalStrut(12));
        JButton ok = new JButton("OK, jetzt wei ich ganz genau Bescheid...", LIZENZ);
        ok.setToolTipText("Anklicken um weiterzuspielen");
        ok.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        ok.setAlignmentX(Component.CENTER_ALIGNMENT);
        feld.add(ok);
        setContentPane(feld);
        getRootPane().setDefaultButton(ok);
        pack();

    }

    /**
     * Realisiert Vernderungen des Look&Feel.
     *
     * @param event
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

}
