/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Signal;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Statistik;
import jafuffy.logik.Turnier;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Ende
extends WindowAdapter
implements ChangeListener {
    private final Eigenschaften eigenschaften;
    private final Statistik statistik;
    private Turnier turnier;

    public Ende(Eigenschaften eigenschaften, Statistik statistik) {
        this.eigenschaften = eigenschaften;
        this.statistik = statistik;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.turnier = (Turnier)ce.getSource();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.turnier = null;
                }
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent we) {
        Window fenster = we.getWindow();
        if (Eigenschaften.GLOBAL.neustart() || JOptionPane.showConfirmDialog(fenster, "JaFuffy beenden?", "JaFuffy (Frage)", 0) == 0) {
            this.sichereTurnierEigenschaften(fenster);
            this.sichereStatistik(fenster);
            this.beendeApplikation();
        }
    }

    private void beendeApplikation() {
        if (this.turnier != null) {
            this.turnier.beende();
        }
        System.exit(0);
    }

    private void sichereStatistik(Window fenster) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.eigenschaften.datei("Statistik.obj")));
            out.writeObject(this.statistik);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "Statistik konnte nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }

    private void sichereTurnierEigenschaften(Window fenster) {
        try {
            this.eigenschaften.speichere(fenster.getX(), fenster.getY(), fenster.getWidth(), fenster.getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "JaFuffy-Einstellungen konnten nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }
}

