/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Auswahl;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Tabelle;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEWuerfel;
import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Turnier;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Zettel
extends JScrollPane
implements ChangeListener {
    static final ImageIcon[] WUERFEL = new ImageIcon[6];
    private final JPanel zeilenkoepfe;
    private Auswahl auswahl;
    private int hoehe;

    static {
        int i = 0;
        while (i <= 5) {
            Zettel.WUERFEL[i] = Grafik.icon("Wuerfelchen" + (i + 1) + ".gif");
            ++i;
        }
        i = 0;
        while (i <= 5) {
            Zettel.WUERFEL[i] = Grafik.icon("Wuerfelchen" + (i + 1) + ".gif");
            ++i;
        }
    }

    Zettel() {
        this.setCorner("UPPER_LEFT_CORNER", this.erzeugeEcke());
        this.zeilenkoepfe = this.erzeugeZeilenkoepfe();
        this.setzeIcons();
        this.setRowHeaderView(this.zeilenkoepfe);
        this.synchronisiereZeilenhoehen();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            Turnier turnier = (Turnier)cej.quelle(Turnier.class);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.auswahl = turnier.auswahl();
                    this.getViewport().setView(new Tabelle(turnier.punkte(), this.auswahl));
                    break;
                }
                case GEWUERFELT: {
                    this.auswahl.gewuerfelt();
                    break;
                }
                case PAUSE: {
                    ((Punkte)tabelle.getModel()).auswaehlbar(false);
                    break;
                }
                case GESETZT: 
                case RUECKGAENGIG: 
                case RESULTAT: {
                    ((Punkte)tabelle.getModel()).auswaehlbar(true);
                    break;
                }
                case VORGESCHLAGEN: {
                    this.auswahl.cancelCellEditing();
                    tabelle.stateChanged(ce);
                    break;
                }
            }
        } else if (CEJaFuffy.adressiert(ce, CEWuerfel.class) && tabelle != null) {
            tabelle.stateChanged(ce);
        }
    }

    private void aktualisiereTabellengroesse() {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        int breite = tabelle.breite();
        this.hoehe = this.zeilenkoepfe.getPreferredSize().height;
        tabelle.setPreferredScrollableViewportSize(new Dimension(breite, this.hoehe));
    }

    private void aktualisiereZeilenhoehe() {
        Tabelle tabelle = (Tabelle)this.getViewport().getView();
        if (tabelle != null) {
            int zeile = 0;
            while (zeile < tabelle.getRowCount()) {
                tabelle.setRowHeight(zeile, this.zeilenkoepfe.getComponent(zeile).getHeight());
                ++zeile;
            }
        }
    }

    private JLabel erzeugeEcke() {
        JLabel ecke = new JLabel("JaFuffy");
        ecke.setHorizontalAlignment(0);
        ecke.setToolTipText("Felderl\u00e4uterungen siehe Hilfethemen");
        ecke.setBackground(Color.GRAY.darker());
        ecke.setForeground(Color.WHITE);
        ecke.setOpaque(true);
        ecke.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 2));
        return ecke;
    }

    private JPanel erzeugeZeilenkoepfe() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Tabzeile[] tabzeileArray = Tabzeile.values();
        int n = tabzeileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Zeilenkopf zeilenkopf;
            Tabzeile z = tabzeileArray[n2];
            switch (z) {
                case GESAMT: 
                case OSUMME: 
                case USUMME: {
                    zeilenkopf = new ZeilenkopfZwischen();
                    break;
                }
                case ESUMME: {
                    zeilenkopf = new ZeilenkopfEnde();
                    break;
                }
                default: {
                    zeilenkopf = new Zeilenkopf();
                }
            }
            zeilenkopf.setText(z.bezeichnung());
            zeilenkopf.setToolTipText(z.beschreibung());
            zeilenkopf.setFont(zeilenkopf.getFont().deriveFont(1));
            zeilenkopf.setOpaque(true);
            panel.add(zeilenkopf);
            ++n2;
        }
        return panel;
    }

    private void setzeIcons() {
        Tabzeile[] tabzeileArray = Tabzeile.OBEN;
        int n = Tabzeile.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            int ind = z.ordinal();
            Zeilenkopf zeilenkopf = (Zeilenkopf)this.zeilenkoepfe.getComponent(ind);
            zeilenkopf.setHorizontalTextPosition(10);
            zeilenkopf.setIcon(WUERFEL[ind]);
            ++n2;
        }
    }

    private void synchronisiereZeilenhoehen() {
        this.getViewport().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent event) {
                Zettel.this.aktualisiereTabellengroesse();
                Zettel.this.aktualisiereZeilenhoehe();
            }
        });
        this.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Zettel.this.aktualisiereZeilenhoehe();
            }
        });
    }

    private class Zeilenkopf
    extends JLabel {
        private static final int DECKELABSTAND = 4;
        private static final int SEITENABSTAND = 2;

        Zeilenkopf() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.faerbe();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.faerbe();
        }

        protected void faerbe() {
            this.setForeground(Color.DARK_GRAY);
        }
    }

    private class ZeilenkopfEnde
    extends Zeilenkopf {
        private ZeilenkopfEnde() {
        }

        @Override
        protected void faerbe() {
            this.setBackground(Zettel.this.getBackground().darker());
            this.setForeground(Color.BLACK);
        }
    }

    private class ZeilenkopfZwischen
    extends Zeilenkopf {
        private ZeilenkopfZwischen() {
        }

        @Override
        protected void faerbe() {
            Color bg1 = Zettel.this.getBackground();
            Color bg2 = bg1.darker();
            Color neu = new Color((bg1.getRed() + bg2.getRed()) / 2, (bg1.getGreen() + bg2.getGreen()) / 2, (bg1.getBlue() + bg2.getBlue()) / 2);
            this.setBackground(neu);
            this.setForeground(Color.BLACK);
        }
    }
}

