/******************************************************************************
 ** $Id: Update.java 746 2015-07-18 22:46:03Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/

package jafuffy.logik;

import jafuffy.bedienung.Signal;

import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;

import javax.swing.JOptionPane;

/** Suche nach neuerer Version auf Homepage. */
public class Update {

    /** Download-URL von dem JaFuffy Web-Auftritt. */
    private static final String DOWNLOAD = "http://jafuffy.3kelvin.de/download.html";
    /** Link, wo die Information zur neuesten Version von JaFuffy abliegt. */
    private static final URL LATEST;
    static {
        URL latest = null;
        try {
            latest = new URL("http://jafuffy.3kelvin.de/jafuffy.mf");
        } catch (MalformedURLException exception) {
            exception.printStackTrace();
        }
        LATEST = latest;
    }

    /**
     * Nach neuer Version schauen, falls bei Programmstart erwnscht.
     *
     * @param aktiviert
     *            Gibt an, ob die berprfung auf eine neuere Version aktiviert ist.
     * @param umgebung
     *            Die Umgebungskomponente, bezglich welcher der Prfungsergebnisdialog
     *            zentriert wird.
     */
    public void ueberpruefe(boolean aktiviert, Component umgebung) {
        if (aktiviert) {
            pruefe(false, umgebung);
        }
    }

    /**
     * berprft auf neuere Version, gibt Hinweise und fragt nach, ob auf die Downloadseite
     * gegangen werden soll.
     *
     * @param umgebung
     *            Die Umgebungskomponente, bezglich welcher der Prfungsergebnisdialog
     *            zentriert wird.
     */
    public void ueberpruefe(Component umgebung) {
        pruefe(true, umgebung);
    }

    /**
     * Schaut auf JaFuffy-Homepage nach neuester Version.
     *
     * @param umgebung
     *            Die Umgebungskomponente, bezglich welcher der Prfungsergebnisdialog
     *            zentriert wird.
     *
     * @return Versionsstring (Nullreferenz, wenn keine Version ermittelt werden kann)
     */
    private String ermittleLetzteVersion(Component umgebung) {
        String titel = new String();
        String version = null;
        Scanner in;

        // "jafuffy.mf" im Web ffnen und parsen
        try {
            in = new Scanner(new BufferedReader(new InputStreamReader(LATEST.openStream())));
            String token;
            while (in.hasNext()) {
                token = in.next();
                if (token.equals("Implementation-Version:")) {
                    version = in.nextLine().trim();
                } else if (token.equals("Implementation-Title:")) {
                    titel = in.next();
                }
            }
            in.close();
        } catch (Exception exception) {
            exception.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(umgebung,
                    "Kann keine Information von der JaFuffy-Homepage holen:\n" + exception
                            + "\n" + "(" + "Die Suche bei Programmstart "
                            + "kann im Men \"Einstellungen\" unterbunden werden." + ")",
                    "JaFuffy (Fehler)", JOptionPane.ERROR_MESSAGE);
            return null;
        }

        // Version nur zurckgeben, falls Titel auch stimmt
        return titel.equals("JaFuffy") ? version : null;
    }

    /**
     * Prft auf neueren Stand und teilt je nach Wunsch Ergebnis mit. Internetverbindungsfehler
     * werden nur auf Standardausgabe ausgegeben und sonst nicht weiter gemeldet.
     *
     * @param benutzeraktiviert
     *            Falls wahr (also durch Benutzer gezielt aktivierte berprfung), erfolgt ein
     *            Hinweis, wenn es keinen neueren Stand gibt; ansonsten gibt es keinen Hinweis.
     * @param umgebung
     *            Die Umgebungskomponente, bezglich welcher der Prfungsergebnisdialog
     *            zentriert wird.
     */
    private void pruefe(boolean benutzeraktiviert, Component umgebung) {
        String installierteVersion = Package.getPackage("jafuffy").getImplementationVersion();
        String neuesteVersion = ermittleLetzteVersion(umgebung);
        if (neuesteVersion != null) {
            if (installierteVersion != null
                    && neuesteVersion.compareTo(installierteVersion) <= 0) {
                if (benutzeraktiviert) {
                    JOptionPane.showMessageDialog(umgebung,
                            "Keine neuere Version auf der JaFuffy-Homepage vorhanden,\n"
                                    + "keine Aktion notwendig.", "JaFuffy (Hinweis)",
                            JOptionPane.INFORMATION_MESSAGE);
                }
            } else if (JOptionPane.showConfirmDialog(umgebung,
                    "Neuere Version gefunden auf der JaFuffy-Homepage,\n"
                            + "zur Downloadseite gehen?", "JaFuffy (Frage)",
                    JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                try {
                    Desktop.getDesktop().browse(new URI(DOWNLOAD));
                } catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

}
