/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

public final class Kombinatorik {
    public static final int VARIATIONEN = 7776;
    public static final double AUSLASSUNGSWAHRSCHEINLICHKEIT = 0.8333333333333334;
    private static final double[] AUGENZAHLEN = new double[]{0.0, 3.5, 4.25, 4.666666666666667};
    private static final double[] GLEICHENWAHRSCHEINLICHKEIT = new double[]{0.09259259259259259, 0.6944444444444444, 0.19290123456790123, 0.019290123456790122, 7.716049382716049E-4};
    private static final int[][] STIRLING2 = new int[6][];

    static {
        Kombinatorik.STIRLING2[0] = new int[1];
        Kombinatorik.STIRLING2[0][0] = 1;
        int n = 1;
        while (n <= 5) {
            Kombinatorik.STIRLING2[n] = new int[n + 1];
            Kombinatorik.STIRLING2[n][0] = 0;
            int k = 1;
            while (k < n) {
                Kombinatorik.STIRLING2[n][k] = k * STIRLING2[n - 1][k] + STIRLING2[n - 1][k - 1];
                ++k;
            }
            Kombinatorik.STIRLING2[n][n] = 1;
            ++n;
        }
    }

    public static double augenzahl(int rest) {
        return AUGENZAHLEN[rest];
    }

    public static int binom(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (2 * k > n) {
            return Kombinatorik.binom(n, n - k);
        }
        int koeffizient = 1;
        n -= k;
        int i = 1;
        while (i <= k) {
            koeffizient *= ++n;
            koeffizient /= i;
            ++i;
        }
        return koeffizient;
    }

    public static int fakultaet(int n) {
        int p = 1;
        while (n > 0) {
            p *= n;
            --n;
        }
        return p;
    }

    public static int fallend(int n, int k) {
        int p;
        if (k < 0) {
            p = 0;
        } else {
            p = 1;
            int i = 0;
            while (i < k) {
                p *= n;
                ++i;
                --n;
            }
        }
        return p;
    }

    public static double gleichenmittel(int n, int r) {
        double p = 1.0 - Math.pow(0.8333333333333334, r);
        return (double)n * p;
    }

    public static double gleichenwahrscheinlichkeit(int m) {
        return GLEICHENWAHRSCHEINLICHKEIT[m - 1];
    }

    public static double gleichenwahrscheinlichkeit(int n, int r) {
        double p = 1.0 - Math.pow(0.8333333333333334, r);
        return Math.pow(p, n);
    }

    public static double gleichenwahrscheinlichkeit(int n, int k, int r) {
        double p = 1.0 - Math.pow(0.8333333333333334, r);
        return (double)Kombinatorik.binom(n, k) * Math.pow(p, k) * Math.pow(1.0 - p, n - k);
    }

    public static double mindestgleichenwahrscheinlichkeit(int min) {
        return Kombinatorik.mindestgleichenwahrscheinlichkeit(5, min, 3);
    }

    public static double mindestgleichenwahrscheinlichkeit(int n, int min, int r) {
        double p = 0.0;
        int k = min;
        while (k <= 5) {
            p += Kombinatorik.gleichenwahrscheinlichkeit(n, k, r);
            ++k;
        }
        return p;
    }

    public static int stirling2(int n, int k) {
        if (k <= n) {
            return STIRLING2[n][k];
        }
        return 0;
    }

    public static int strassenteilschablone(int n, int d, int k) {
        int summe = 0;
        int i = k;
        while (i <= n) {
            summe = (int)((double)summe + (double)(Kombinatorik.stirling2(i, k) * Kombinatorik.binom(n, i)) * Math.pow(d, n - i));
            ++i;
        }
        return summe;
    }

    public static double strassenteilsequenz(int n, int d, int k, int m) {
        return Kombinatorik.fallend(m, k) * Kombinatorik.strassenteilschablone(n, d, k);
    }

    private Kombinatorik() {
    }
}

