/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Analyse;
import jafuffy.logik.Kombinatorik;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Klassisch;

public class ImHieb
extends Klassisch {
    private static final long serialVersionUID = 447027133112163377L;

    public ImHieb(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    protected Analyse.Basiseintragungen eintragungen() {
        return new Eintragungen();
    }

    class Eintragungen
    extends Analyse.Basiseintragungen {
        private static final long serialVersionUID = -226404933174352144L;

        Eintragungen() {
            this.put(Tabzeile.DREIERPASCH, new Pasch(3));
            this.put(Tabzeile.VIERERPASCH, new Pasch(4));
            this.put(Tabzeile.FULLHOUSE, new FullHouse());
            this.put(Tabzeile.KLEINESTRASSE, new KleineStrasse());
            this.put(Tabzeile.GROSSESTRASSE, new GrosseStrasse());
            this.put(Tabzeile.JAFUFFY, new JaFuffy());
        }
    }

    class FullHouse
    extends Klassisch.FullHouse {
        private static final long serialVersionUID = -3227165375021646796L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.19675925925925927;

        FullHouse() {
            super(ImHieb.this);
            this.mittel += 0.19675925925925927;
        }
    }

    class GrosseStrasse
    extends Klassisch.GrosseStrasse {
        private static final long serialVersionUID = -2371420977396166725L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.15432098765432098;

        GrosseStrasse() {
            super(ImHieb.this);
            this.mittel += 0.15432098765432098;
        }
    }

    class JaFuffy
    extends Klassisch.JaFuffy {
        private static final long serialVersionUID = -4640248861129674120L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.023148148148148147;

        JaFuffy() {
            super(ImHieb.this);
            this.mittel += 0.023148148148148147;
        }
    }

    class KleineStrasse
    extends Klassisch.KleineStrasse {
        private static final long serialVersionUID = 1874639430274154259L;
        private static final double IM_HIEB_BONUS_MITTEL = 0.7716049382716049;

        KleineStrasse() {
            super(ImHieb.this);
            this.mittel += 0.7716049382716049;
        }
    }

    class Pasch
    extends Klassisch.Pasch {
        private static final long serialVersionUID = -626035053170491772L;

        Pasch(int pasch) {
            super(ImHieb.this, pasch);
            double s = 0.0;
            int k = pasch;
            while (k <= 5) {
                s += (double)(Kombinatorik.binom(5, k) * 6) * Math.pow(5.0, 5 - k);
                ++k;
            }
            this.mittel += s / 7776.0;
        }
    }
}

