/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Analyse;
import jafuffy.logik.Kombinatorik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Klassisch
extends Analyse {
    private static final long serialVersionUID = -3852043350163717864L;

    public Klassisch(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    protected Analyse.Basiseintragungen eintragungen() {
        return new Eintragungen();
    }

    protected class Eintragungen
    extends Analyse.Basiseintragungen {
        private static final long serialVersionUID = -7416744679857533889L;

        Eintragungen() {
            this.put(Tabzeile.DREIERPASCH, new Pasch(3));
            this.put(Tabzeile.VIERERPASCH, new Pasch(4));
            this.put(Tabzeile.FULLHOUSE, new FullHouse());
            this.put(Tabzeile.KLEINESTRASSE, new KleineStrasse());
            this.put(Tabzeile.GROSSESTRASSE, new GrosseStrasse());
            this.put(Tabzeile.JAFUFFY, new JaFuffy());
        }
    }

    class FullHouse
    extends Analyse.Unten {
        private static final long serialVersionUID = -1069152277729232203L;
        static final int PUNKTE = 25;
        private final double[] restwahrscheinlichkeit = new double[]{0.03935185185185185, 0.23148148148148148, 0.1736111111111111, 0.46296296296296297, 0.0, 0.09259259259259259};
        private int fehlend;

        FullHouse() {
            this.mittel = this.prognose(5, 3);
        }

        private boolean istFullHouse() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH) != false && (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }

        private double prognose(int k, int r) {
            return 25.0 * this.restwahrscheinlichkeit(k, r);
        }

        private double restwahrscheinlichkeit(int k, int r) {
            switch (k) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return 1.0 - Math.pow(0.6666666666666666, r);
                }
                case 2: {
                    return 1.0 - Math.pow(0.8333333333333334, r);
                }
                case 3: {
                    switch (r) {
                        case 1: {
                            return 0.09722222222222222;
                        }
                        case 2: {
                            return 0.27469135802469136;
                        }
                    }
                    return 0.0;
                }
                case 5: {
                    if (r == 0) {
                        return 0.0;
                    }
                    double p = 0.0;
                    int i = 0;
                    while (i <= 5) {
                        p += this.restwahrscheinlichkeit[i] * this.restwahrscheinlichkeit(i, r - 1);
                        ++i;
                    }
                    return p;
                }
            }
            return 0.0;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            return this.prognose(this.fehlend, spieler.rest());
        }

        @Override
        protected int punkte() {
            return this.istFullHouse() ? 25 : 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            if (this.istFullHouse()) {
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                int n = wuerfelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel w = wuerfelArray[n2];
                    this.neuwurfkarte.put(w, false);
                    ++n2;
                }
                this.fehlend = 0;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH)).booleanValue() || ((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH)).booleanValue()) {
                int zaehler = 0;
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                int n = wuerfelArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Wuerfel w;
                    this.neuwurfkarte.put(w, (w = wuerfelArray[n3]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.DREIERPASCH.groesse() || zaehler == Analyse.Paschaufzaehlung.DREIERPASCH.groesse());
                    if (w.vorkommen(Klassisch.this.augenhaeufigkeiten) >= Analyse.Paschaufzaehlung.DREIERPASCH.groesse()) {
                        ++zaehler;
                    }
                    ++n3;
                }
                this.fehlend = 2;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH)).booleanValue()) {
                this.fehlend = 0;
                Object[] objectArray = Klassisch.this.augenhaeufigkeiten;
                int n = objectArray.length;
                int n4 = 0;
                while (n4 < n) {
                    int haeufigkeit = objectArray[n4];
                    if (haeufigkeit == Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse()) {
                        this.fehlend = this.fehlend == 0 ? 3 : 1;
                    }
                    ++n4;
                }
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                objectArray = wuerfelArray;
                n = wuerfelArray.length;
                n4 = 0;
                while (n4 < n) {
                    int w;
                    this.neuwurfkarte.put(w, (w = objectArray[n4]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse());
                    ++n4;
                }
            } else {
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                int n = wuerfelArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Wuerfel w = wuerfelArray[n5];
                    this.neuwurfkarte.put(w, true);
                    ++n5;
                }
                this.fehlend = 5;
            }
        }
    }

    public class GrosseStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 8292592862416663732L;
        public static final int PUNKTE = 40;
        private final int[] kandidat = new int[6];
        private int fehlend;

        GrosseStrasse() {
            this.mittel = 40.0 * this.q(5, 3);
        }

        private double p(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int i = 0;
                while (i <= n) {
                    summe += this.u(n, i) * this.p(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            return (double)Kombinatorik.fakultaet(n) / Math.pow(6.0, n);
        }

        private double q(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int i = 0;
                while (i <= n) {
                    summe += this.w(n, i) * this.p(n - i, r - 1) + this.v(n, i) * this.q(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            if (n > 0) {
                return (double)(2 * Kombinatorik.fakultaet(n)) / Math.pow(6.0, n);
            }
            return 0.0;
        }

        private double u(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 6 - n, i, n) / Math.pow(6.0, n);
        }

        private double v(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 5 - n, i, n - 1) / Math.pow(6.0, n);
        }

        private double w(int n, int i) {
            return (double)(i * Kombinatorik.fallend(n - 1, i - 1) * (2 * Kombinatorik.strassenteilschablone(n, 5 - n, i) + (i + 1) * Kombinatorik.strassenteilschablone(n, 5 - n, i + 1))) / Math.pow(6.0, n);
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            if (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0) {
                return 40.0 * this.p(this.fehlend, spieler.rest());
            }
            return 40.0 * this.q(this.fehlend, spieler.rest());
        }

        @Override
        protected int punkte() {
            if (Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.DREIER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.VIERER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 || Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1)) {
                return 40;
            }
            return 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            System.arraycopy(Klassisch.this.augenhaeufigkeiten, 0, this.kandidat, 0, 6);
            if (this.kandidat[Analyse.Index.EINSER.ordinal()] > 0 && this.kandidat[Analyse.Index.SECHSER.ordinal()] > 0) {
                if (ZUFALL.nextBoolean()) {
                    this.kandidat[Analyse.Index.EINSER.ordinal()] = 0;
                } else {
                    this.kandidat[Analyse.Index.SECHSER.ordinal()] = 0;
                }
            }
            this.fehlend = 0;
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w;
                int i = (w = wuerfelArray[n2]).augen() - 1;
                this.neuwurfkarte.put(w, this.kandidat[i] == 0);
                if (((Boolean)this.neuwurfkarte.get(w)).booleanValue()) {
                    ++this.fehlend;
                } else {
                    this.kandidat[i] = 0;
                }
                ++n2;
            }
        }
    }

    class JaFuffy
    extends Analyse.Unten {
        private static final long serialVersionUID = -6921954073317063844L;
        static final int PUNKTE = 50;

        JaFuffy() {
            this.mittel = this.prognose(0, 3);
        }

        private double p(int max, int r) {
            if (r > 0) {
                double p = 0.0;
                if (max <= 1) {
                    int i = 1;
                    while (i <= 5) {
                        p += Kombinatorik.gleichenwahrscheinlichkeit(i) * this.p(i, r - 1);
                        ++i;
                    }
                } else {
                    p = max == 2 ? (80.0 * Kombinatorik.gleichenwahrscheinlichkeit(2, r - 1) + 15.0 * Kombinatorik.gleichenwahrscheinlichkeit(1, r - 1) + 1.0 + 120.0 * this.p(2, r - 1)) / 216.0 : Kombinatorik.gleichenwahrscheinlichkeit(5 - max, r);
                }
                return p;
            }
            return max == 5 ? 1 : 0;
        }

        private double prognose(int max, int r) {
            return this.p(max, r) * 50.0;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            return this.prognose(spieler.rest(), this.maxgleich());
        }

        @Override
        protected int punkte() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false ? 50 : 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            int max = this.maxgleich();
            ArrayList<Integer> augenauswahl = new ArrayList<Integer>();
            int ind = 0;
            while (ind < 6) {
                if (Klassisch.this.augenhaeufigkeiten[ind] == max) {
                    augenauswahl.add(new Integer(ind + 1));
                }
                ++ind;
            }
            int augen = (Integer)augenauswahl.get(ZUFALL.nextInt(augenauswahl.size()));
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                this.neuwurfkarte.put(w, max == 1 || augen != w.augen());
                ++n2;
            }
        }
    }

    public class KleineStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 3736058022544823661L;
        private static final double P_TOT = 0.6025279;
        public static final int PUNKTE = 30;
        private int aussen;
        private int innen;
        private int mitte;

        KleineStrasse() {
            this.mittel = 18.075837;
        }

        private void behalte(Strassenpaar paar) {
            Analyse.Index[] indexArray = paar.feld();
            int n = indexArray.length;
            int n2 = 0;
            while (n2 < n) {
                Analyse.Index element = indexArray[n2];
                if (element.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0) {
                    Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                    int n3 = wuerfelArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Wuerfel w = wuerfelArray[n4];
                        if (w.augen() == element.augen()) {
                            this.neuwurfkarte.put(w, false);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            if (this.aussen + this.innen + this.mitte < 4) {
                return KleineStrasseIndex.TABELLE.get(new KleineStrasseIndex(this.aussen, this.innen, this.mitte, spieler.rest())) * 30.0;
            }
            return 30.0;
        }

        @Override
        protected int punkte() {
            if (Analyse.Index.DREIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.VIERER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0)) {
                return 30;
            }
            return 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                this.neuwurfkarte.put(w, true);
                ++n2;
            }
            this.aussen = 0;
            this.innen = Strassenpaar.INNEN.vorkommen(Klassisch.this.augenhaeufigkeiten);
            this.mitte = Strassenpaar.MITTE.vorkommen(Klassisch.this.augenhaeufigkeiten);
            int links = Strassenpaar.LINKS.vorkommen(Klassisch.this.augenhaeufigkeiten);
            int rechts = Strassenpaar.RECHTS.vorkommen(Klassisch.this.augenhaeufigkeiten);
            if (this.innen == 2) {
                this.behalte(Strassenpaar.INNEN);
            } else if (this.innen == 1 && links <= 1 && rechts <= 1) {
                this.behalte(Strassenpaar.INNEN);
            } else if (links > rechts) {
                this.aussen = links - this.innen;
                this.behalte(Strassenpaar.LINKS);
            } else if (links < rechts) {
                this.aussen = rechts - this.innen;
                this.behalte(Strassenpaar.RECHTS);
            } else {
                this.aussen = links - this.innen;
                this.behalte(ZUFALL.nextBoolean() ? Strassenpaar.LINKS : Strassenpaar.RECHTS);
            }
            this.behalte(Strassenpaar.MITTE);
        }
    }

    private static class KleineStrasseIndex
    implements Serializable {
        private static final long serialVersionUID = -6498075827504305923L;
        static final Map<KleineStrasseIndex, Double> TABELLE = new HashMap<KleineStrasseIndex, Double>();
        private final int aussen;
        private final int innen;
        private final int mitte;
        private final int rest;

        static {
            KleineStrasseIndex.tabelliere(0, 0, 1, 1, 0.212963);
            KleineStrasseIndex.tabelliere(0, 0, 1, 2, 0.489169);
            KleineStrasseIndex.tabelliere(0, 0, 2, 1, 0.3611111);
            KleineStrasseIndex.tabelliere(0, 0, 2, 2, 0.6584362);
            KleineStrasseIndex.tabelliere(0, 1, 0, 1, 0.1481481);
            KleineStrasseIndex.tabelliere(0, 1, 0, 2, 0.3912751);
            KleineStrasseIndex.tabelliere(0, 1, 1, 1, 0.25);
            KleineStrasseIndex.tabelliere(0, 1, 1, 2, 0.5150463);
            KleineStrasseIndex.tabelliere(0, 1, 2, 1, 0.5555556);
            KleineStrasseIndex.tabelliere(0, 1, 2, 2, 0.8024691);
            KleineStrasseIndex.tabelliere(0, 2, 0, 1, 0.1388889);
            KleineStrasseIndex.tabelliere(0, 2, 0, 2, 0.3526235);
            KleineStrasseIndex.tabelliere(0, 2, 1, 1, 0.3055556);
            KleineStrasseIndex.tabelliere(0, 2, 1, 2, 0.5177469);
            KleineStrasseIndex.tabelliere(1, 0, 0, 1, 0.1018519);
            KleineStrasseIndex.tabelliere(1, 0, 0, 2, 0.3410851);
            KleineStrasseIndex.tabelliere(1, 0, 1, 1, 0.1666667);
            KleineStrasseIndex.tabelliere(1, 0, 1, 2, 0.4293981);
            KleineStrasseIndex.tabelliere(1, 0, 2, 1, 0.3611111);
            KleineStrasseIndex.tabelliere(1, 0, 2, 2, 0.6296296);
            KleineStrasseIndex.tabelliere(1, 1, 0, 1, 0.1388889);
            KleineStrasseIndex.tabelliere(1, 1, 0, 2, 0.3526235);
            KleineStrasseIndex.tabelliere(1, 1, 1, 1, 0.3055556);
            KleineStrasseIndex.tabelliere(1, 1, 1, 2, 0.5177469);
        }

        private static void tabelliere(int aussen, int innen, int mitte, int rest, double p) {
            TABELLE.put(new KleineStrasseIndex(aussen, innen, mitte, rest), p);
        }

        KleineStrasseIndex(int aussen, int innen, int mitte, int rest) {
            this.aussen = aussen;
            this.innen = innen;
            this.mitte = mitte;
            this.rest = rest;
        }

        public boolean equals(Object obj) {
            KleineStrasseIndex index = (KleineStrasseIndex)obj;
            return this.aussen == index.aussen && this.innen == index.innen && this.mitte == index.mitte && this.rest == index.rest;
        }

        public int hashCode() {
            return 3 * (3 * (3 * this.aussen + this.innen) + this.mitte) + this.rest;
        }
    }

    class Pasch
    extends Analyse.Unten {
        private static final long serialVersionUID = 8666151619656864766L;
        public static final int KLEIN = 3;
        public static final int GROSS = 4;
        private final int pasch;
        private int versuch;

        Pasch(int pasch) {
            this.pasch = pasch;
            this.mittel = 0.0;
            int augen = 1;
            while (augen <= 6) {
                int max = 1;
                while (max <= 5) {
                    this.mittel += this.prognose(max, 2, augen) * this.q(max, augen);
                    ++max;
                }
                ++augen;
            }
        }

        private double augenzahl(int m, int j, int augen) {
            double grenze = Kombinatorik.augenzahl(j);
            int n = (int)grenze;
            double punkte = (double)(this.pasch * augen) + (double)(m - this.pasch) * Math.max((double)augen, grenze);
            double s = (double)((n + 7) * (6 - n)) / 2.0;
            if ((double)augen <= grenze) {
                double alpha = (double)(n - 1) / 5.0;
                punkte += (double)(5 - m) * (alpha * grenze + (1.0 - alpha) * s / (double)(6 - n));
            } else {
                double alpha = (double)n / 5.0;
                punkte += (double)(5 - m) * (alpha * grenze + (1.0 - alpha) * (s - (double)augen) / (double)(5 - n));
            }
            return punkte;
        }

        private boolean pasch() {
            return this.pasch == 3 && (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }

        private double prognose(int max, int r, int augen) {
            double punkte = 0.0;
            if (max < this.pasch) {
                int n = 5 - max;
                int k = this.pasch - max;
                while (k <= n) {
                    int j = 1;
                    while (j <= r) {
                        double gw0 = Kombinatorik.gleichenwahrscheinlichkeit(n, k, j);
                        double gw1 = Kombinatorik.gleichenwahrscheinlichkeit(n, k, j - 1);
                        punkte += (gw0 - gw1) * this.augenzahl(max + k, j - 1, augen);
                        ++j;
                    }
                    ++k;
                }
            } else if (Klassisch.this.wuerfel != null) {
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                int n = wuerfelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel w = wuerfelArray[n2];
                    punkte = ((Boolean)this.neuwurfkarte.get(w)).booleanValue() ? (punkte += Kombinatorik.augenzahl(r)) : (punkte += (double)w.augen());
                    ++n2;
                }
            } else {
                punkte = this.augenzahl(max, 2, augen);
            }
            return punkte;
        }

        private double q(int max, int augen) {
            if (max >= 3) {
                return Kombinatorik.gleichenwahrscheinlichkeit(max) / 6.0;
            }
            if (max == 2) {
                return ((double)(augen - 1) * 120.0 + 600.0) / 7776.0;
            }
            if (augen <= 4) {
                return 0.0;
            }
            if (augen == 5) {
                return 0.015432098765432098;
            }
            return 0.07716049382716049;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            return this.prognose(this.maxgleich(), spieler.rest(), this.versuch);
        }

        @Override
        protected int punkte() {
            return this.pasch() ? Klassisch.this.augensumme : 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            this.versuch = 6;
            while (Klassisch.this.augenhaeufigkeiten[this.versuch - 1] < this.maxgleich()) {
                --this.versuch;
            }
            int zaehler = 0;
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                boolean kandidat = w.augen() == this.versuch ? ++zaehler > this.pasch && Kombinatorik.augenzahl(spieler.rest()) > (double)w.augen() : !this.pasch() || Kombinatorik.augenzahl(spieler.rest()) > (double)w.augen();
                this.neuwurfkarte.put(w, kandidat);
                ++n2;
            }
        }
    }

    private static enum Strassenpaar {
        LINKS(Analyse.Index.EINSER, Analyse.Index.ZWEIER),
        INNEN(Analyse.Index.ZWEIER, Analyse.Index.FUENFER),
        RECHTS(Analyse.Index.FUENFER, Analyse.Index.SECHSER),
        MITTE(Analyse.Index.DREIER, Analyse.Index.VIERER);

        private final Analyse.Index[] feld = new Analyse.Index[2];

        private Strassenpaar(Analyse.Index paar0, Analyse.Index paar1) {
            this.feld[0] = paar0;
            this.feld[1] = paar1;
        }

        final Analyse.Index[] feld() {
            return this.feld;
        }

        int vorkommen(int[] augenhaeufigkeiten) {
            int gefunden = 0;
            Analyse.Index[] indexArray = this.feld;
            int n = this.feld.length;
            int n2 = 0;
            while (n2 < n) {
                Analyse.Index element = indexArray[n2];
                if (element.vorkommen(augenhaeufigkeiten) > 0) {
                    ++gefunden;
                }
                ++n2;
            }
            return gefunden;
        }
    }
}

