/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import java.io.Serializable;
import java.util.HashMap;

public class Spieler
implements Comparable<Spieler>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5170511106942700515L;
    public static final int SPIELER = 4;
    static final int GRENZE = 63;
    static final int BONUS = 35;
    private final String name;
    private final int max;
    private final HashMap<Tabzeile, Integer> punktzahlen = new HashMap(Tabzeile.ANZAHL);
    private final HashMap<Tabzeile, Boolean> setzbarkeiten = new HashMap(Tabzeile.ANZAHL);
    private int rest;
    private boolean gewuerfelt;
    private boolean einmalig;
    private transient Punkte.Meldung meldung;

    public Spieler(String name, int max) {
        this.name = name;
        this.max = max;
        this.initialisiere();
    }

    @Override
    public int compareTo(Spieler spieler) {
        if (this.endsumme() < spieler.endsumme()) {
            return -1;
        }
        if (this.endsumme() > spieler.endsumme()) {
            return 1;
        }
        return 0;
    }

    public boolean einmalig() {
        return this.einmalig;
    }

    public int endsumme() {
        return this.punktzahlen.get((Object)Tabzeile.ESUMME);
    }

    public boolean fertig() {
        return this.rest == 0;
    }

    public boolean gewuerfelt() {
        return this.gewuerfelt;
    }

    public boolean menschlich() {
        return true;
    }

    public boolean neu() {
        return this.max == this.rest;
    }

    public int punkte(Tabzeile eintrag) {
        return this.punktzahlen.get((Object)eintrag);
    }

    public int rest() {
        return this.rest;
    }

    public boolean setzbar(Tabzeile eintrag) {
        return this.setzbarkeiten.get((Object)eintrag);
    }

    public void setze(Tabzeile eintrag, int wert, boolean weiter) {
        Tabzeile z;
        int oben = 0;
        int bonus = 0;
        int unten = 0;
        this.punktzahlen.put(eintrag, wert);
        this.setzbarkeiten.put(eintrag, false);
        Tabzeile[] tabzeileArray = Tabzeile.OBEN;
        int n = Tabzeile.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            z = tabzeileArray[n2];
            oben += this.punktzahlen.get((Object)z).intValue();
            ++n2;
        }
        this.punktzahlen.put(Tabzeile.GESAMT, oben);
        if (this.punktzahlen.get((Object)Tabzeile.GESAMT) >= 63) {
            bonus = 35;
        }
        this.punktzahlen.put(Tabzeile.BONUS, bonus);
        this.punktzahlen.put(Tabzeile.OSUMME, oben + bonus);
        tabzeileArray = Tabzeile.UNTEN;
        n = Tabzeile.UNTEN.length;
        n2 = 0;
        while (n2 < n) {
            z = tabzeileArray[n2];
            unten += this.punktzahlen.get((Object)z).intValue();
            ++n2;
        }
        this.punktzahlen.put(Tabzeile.USUMME, unten);
        this.punktzahlen.put(Tabzeile.ESUMME, oben + bonus + unten);
        if (weiter) {
            this.warte();
        } else {
            this.aktualisiere();
        }
    }

    public String toString() {
        return this.name;
    }

    void aktiviere() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = this.max;
        this.aktualisiere();
    }

    void aktualisiere() {
        if (this.meldung != null) {
            this.meldung.mitteilen();
        }
    }

    int gesamt() {
        return this.punktzahlen.get((Object)Tabzeile.GESAMT);
    }

    void initialisiere() {
        Tabzeile[] tabzeileArray = Tabzeile.values();
        int n = tabzeileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            this.punktzahlen.put(z, 0);
            switch (z) {
                case GESAMT: 
                case BONUS: 
                case OSUMME: 
                case USUMME: 
                case ESUMME: {
                    this.setzbarkeiten.put(z, false);
                    break;
                }
                default: {
                    this.setzbarkeiten.put(z, true);
                }
            }
            ++n2;
        }
        this.warte();
    }

    Spieler kopie() {
        Spieler spieler = new Spieler(this.name, this.max);
        spieler.punktzahlen.putAll(this.punktzahlen);
        spieler.setzbarkeiten.putAll(this.setzbarkeiten);
        spieler.rest = 0;
        spieler.gewuerfelt = true;
        spieler.einmalig = this.einmalig;
        spieler.meldung = this.meldung;
        return spieler;
    }

    void reagiere() {
        this.gewuerfelt = true;
        this.einmalig = this.neu();
        --this.rest;
        this.aktualisiere();
    }

    void verbinde(Punkte.Meldung meldung) {
        this.meldung = meldung;
    }

    void warte() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = 0;
        this.aktualisiere();
    }
}

