/******************************************************************************
 ** $Id: Erweitert.java 875 2016-02-06 22:33:18Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/

package jafuffy.bedienung.auswahl;

import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Turnier;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

/**
 * Auswahl der Zelle, in die das Wrfelresultat gesetzt wird (erweiterte Regeln). Gibt JaFuffy/Joker/Bonus-Meldung aus;
 * fhrt "Zwangssetzung" aus.
 */
@SuppressWarnings("serial")
public class Erweitert extends Klassisch {

    /** Bonuspunkte beim Joker. */
    private static final int JOKERBONUS = jafuffy.logik.auswertung.Erweitert.JOKER;
    /** Anzeigedauer in Millisekunden der Nachricht bei Joker. */
    private static final int JOKERDELAY = 1500;
    /** Anzeigedauer in Millisekunden der Nachricht fr Belegung im oberen Teil bei Joker und vorhandenem JaFuffy. */
    private static final int ZWANGDELAY = 1500;

    /** Die Auswertung zu dieser Auswahl. */
    private final jafuffy.logik.auswertung.Erweitert auswertung;
    /** Setzen des JaFuffy bei JaFuffy-Joker. */
    private final Timer jokertimer = new Timer(JOKERDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            auswertung.zeigeBonusnachricht(false);
            turnier.setze(Tabzeile.JAFUFFY, turnier.aktiver().punkte(Tabzeile.JAFUFFY) + JOKERBONUS);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };
    /** Erzwungenes Setzen zur Belegung im oberen Teil bei JaFuffy-Joker und belegtem JaFuffy. */
    private final Timer zwangtimer = new Timer(ZWANGDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            Tabzeile eintrag = Tabzeile.oben(turnier.wuerfel(0).augen());
            auswertung.zeigeSetzzwangnachricht(false);
            auswertung.zeigeBonusnachricht(false);
            turnier.aktiver().setze(eintrag, auswertung.wert(eintrag), false);
            turnier.setze(Tabzeile.JAFUFFY, turnier.aktiver().punkte(Tabzeile.JAFUFFY) + JOKERBONUS);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };

    /**
     * Konstruktor.
     *
     * @param turnier
     *            Das Turnier, fr welches die Auswahl getroffen werden soll.
     */
    public Erweitert(Turnier turnier) {
        super(turnier);
        auswertung = (jafuffy.logik.auswertung.Erweitert) turnier.auswertung();
    }

    @Override
    public void reagiereAufWurf() {
        aktualisiere();
        if (auswertung.setzzwang()) {
            ((Punkte) tabelle.getModel()).auswaehlbar(false);
            auswertung.zeigeSetzzwangnachricht(true);
            auswertung.zeigeBonusnachricht(true);
            HURRA.play();
            zwangtimer.start();
        } else if (auswertung.istJokerVorliegend()) {
            auswertung.zeigeJokernachricht(true);
        }
    }

    @Override
    protected void reagiereAufSetzen() {
        if (auswertung.istJokerVorliegend()) {
            turnier.pausiere();
            auswertung.zeigeJokernachricht(false);
            auswertung.zeigeBonusnachricht(true);
            turnier.aktiver().setze(aktuell, auswertung.wert(aktuell), false);
            HURRA.play();
            jokertimer.start();
        } else {
            turnier.setze(aktuell);
        }
    }

}
