/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Report;
import jafuffy.logik.Statistik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

class Zwischenstand
extends JPanel {
    private static final String STANDARDHILFE = "Alle bisher im Turnier erspielten Punkte der einzelnen Spieler";
    private static final int BREITE = 400;
    private static final int BALKENDICKE = 15;
    private static final int RAUMEFFEKT = 2;
    private static final int LUECKE = 8;
    private static final int SCHRIFTGROESSE = 12;
    private static final Font FONT = new Font("Dialog", 1, 12);
    private final Statistik statistik;
    private int ausschnitt;
    private int[] staende;
    private String[] namen;
    private Rectangle2D[] balkenrechtecke;
    private Rectangle2D[] beschriftungsrechtecke;

    Zwischenstand(Statistik statistik) {
        this.statistik = statistik;
        this.setBackground(Color.WHITE);
        this.setToolTipText(STANDARDHILFE);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Zwischenstand.this.verteile();
                Zwischenstand.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Zwischenstand.this.beschreibe(event);
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.staende != null) {
            return new Dimension(400, this.staende.length * 23 + 8);
        }
        return new Dimension(400, 100);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.balkenrechtecke != null) {
            g.setFont(FONT);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = this.staende.length;
            int i = 0;
            while (i < n) {
                int l = (int)this.balkenrechtecke[i].getWidth();
                int b = (int)this.balkenrechtecke[i].getHeight();
                int x = (int)this.balkenrechtecke[i].getX();
                int y = (int)this.balkenrechtecke[i].getY() - 1;
                this.zeichne(g, x, y, l, b, Report.FARBEN[i]);
                int d = (int)this.beschriftungsrechtecke[i].getX();
                int m = (int)this.beschriftungsrechtecke[i].getY() + (int)this.beschriftungsrechtecke[i].getHeight() - 1;
                g.drawString(String.valueOf(this.staende[i]), d, m);
                ++i;
            }
        }
    }

    private void anpasse() {
        boolean istAusschnittUeberschritten = false;
        int i = 0;
        while (i < this.staende.length) {
            this.staende[i] = this.statistik.stand(i);
            if (this.staende[i] > this.ausschnitt) {
                istAusschnittUeberschritten = true;
                this.ausschnitt = this.staende[i];
            }
            ++i;
        }
        if (istAusschnittUeberschritten) {
            if (this.statistik.anzahl() == 0) {
                this.ausschnitt *= 2;
            } else {
                int anzahl = this.statistik.rest();
                this.ausschnitt += this.statistik.abweichung() + this.statistik.mittelwert() * anzahl + 2 * this.statistik.abweichung() * (int)Math.sqrt(anzahl);
            }
        }
    }

    private void beschreibe(MouseEvent event) {
        this.setToolTipText(STANDARDHILFE);
        int i = 0;
        while (i < this.staende.length) {
            if (this.balkenrechtecke[i].contains(event.getX(), event.getY()) || this.beschriftungsrechtecke[i].contains(event.getX(), event.getY())) {
                this.setToolTipText("<html><p>Alle bisher im Turnier erspielten Punkte von <strong>" + this.namen[i] + "</strong>" + "</p>" + "</html>");
            }
            ++i;
        }
    }

    private void verteile() {
        if (this.balkenrechtecke != null) {
            int n = this.staende.length;
            int i = 0;
            while (i < n) {
                FontMetrics fm = this.getFontMetrics(FONT);
                int s = fm.stringWidth(String.valueOf(this.ausschnitt));
                int w = fm.charWidth(' ');
                int a = fm.getAscent();
                int l = (this.getWidth() - s - 2 * w - 2) * this.staende[i] / this.ausschnitt;
                int y = (this.getHeight() - n * 15) * (i + 1) / (n + 1) + i * 15;
                this.balkenrechtecke[i].setRect(0.0, y + 2 - 1, l, 15.0);
                this.beschriftungsrechtecke[i].setRect(l + 2 + w, y + 2 - 2 + (15 - a + 1) / 2, s, a);
                ++i;
            }
        }
    }

    private void zeichne(Graphics g, int x, int y, int b, int l, Color farbe) {
        g.setColor(farbe);
        int i = 0;
        while (i < 2) {
            g.fill3DRect(x + 2 - 1 - i, y + i, b, l, true);
            ++i;
        }
    }

    void aktualisiere() {
        this.anpasse();
        this.verteile();
    }

    void starte() {
        int n = this.statistik.spieler().size();
        this.staende = new int[n];
        this.namen = new String[this.staende.length];
        this.balkenrechtecke = new Rectangle2D[this.staende.length];
        this.beschriftungsrechtecke = new Rectangle2D[this.staende.length];
        int anzahl = Integer.max(1, this.statistik.anzahl());
        int i = 0;
        while (i < this.staende.length) {
            this.namen[i] = this.statistik.spieler().get(i).toString();
            this.balkenrechtecke[i] = new Rectangle2D.Double();
            this.beschriftungsrechtecke[i] = new Rectangle2D.Double();
            ++i;
        }
        this.ausschnitt = this.statistik.mittelwert() * anzahl + 2 * this.statistik.abweichung() * (int)Math.sqrt(anzahl);
        this.aktualisiere();
        this.revalidate();
    }
}

