/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Kombinatorik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;

public abstract class Analyse
implements Serializable {
    private static final long serialVersionUID = -6325984568972413728L;
    private static final double NEUTRALWICHTUNG = 1.0;
    protected static final Random ZUFALL = new Random();
    private final Eintragungen eintragungen;
    private Tabzeile optimalzeile;
    protected final int[] augenhaeufigkeiten = new int[6];
    protected final Map<Paschaufzaehlung, Boolean> paschkarte = new HashMap<Paschaufzaehlung, Boolean>(Paschaufzaehlung.values().length, 1.0f);
    protected final Wuerfel[] wuerfel;
    protected int augensumme;

    protected Analyse(Wuerfel[] wuerfel) {
        this.wuerfel = wuerfel;
        this.eintragungen = this.eintragungen();
    }

    public Tabzeile bester() {
        return this.optimalzeile;
    }

    public boolean istVorschlagEntsprechendWuerfelauswahl(Tabzeile eintrag) {
        int[] anzahlenJeAugenAusgewaehlte = new int[6];
        int[] anzahlenJeAugenVorgeschlagene = new int[6];
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            int a = w.augen() - 1;
            if (w.isSelected()) {
                int n3 = a;
                anzahlenJeAugenAusgewaehlte[n3] = anzahlenJeAugenAusgewaehlte[n3] + 1;
            }
            if (this.eintrag(eintrag).erneut(w)) {
                int n4 = a;
                anzahlenJeAugenVorgeschlagene[n4] = anzahlenJeAugenVorgeschlagene[n4] + 1;
            }
            ++n2;
        }
        int a = 0;
        while (a < 6) {
            if (anzahlenJeAugenAusgewaehlte[a] != anzahlenJeAugenVorgeschlagene[a]) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public final int wert(Tabzeile eintrag) {
        return this.eintrag(eintrag).wert();
    }

    public double wichtung(Tabzeile eintrag) {
        return this.eintrag(eintrag).wichtung();
    }

    private Eintrag eintrag(Tabzeile eintrag) {
        return (Eintrag)this.eintragungen.get((Object)eintrag);
    }

    private double findeMaximum(Spieler spieler) {
        double max = 0.0;
        this.optimalzeile = null;
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            double endstand;
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z) && (endstand = this.eintrag(z).endsumme()) > max) {
                this.optimalzeile = z;
                max = endstand;
            }
            ++n2;
        }
        return max;
    }

    private double findeMinimum(Spieler spieler, double max) {
        double min = max;
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            double endstand;
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z) && (endstand = this.eintrag(z).endsumme()) < min) {
                min = endstand;
            }
            ++n2;
        }
        return min;
    }

    private void gewichte(Spieler spieler, double min, double max) {
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z)) {
                if (max - min > 0.0) {
                    double endstand = this.eintrag(z).endsumme();
                    this.eintrag(z).gewichte((endstand - min) / (max - min));
                } else {
                    this.eintrag(z).gewichte(1.0);
                }
            } else {
                this.eintrag(z).gewichte(0.0);
            }
            ++n2;
        }
    }

    private void tippe(Spieler spieler) {
        double mittlererObererZuwachs = 0.0;
        int anzahlObereFreieEintraege = 0;
        int augensummeObereFreieEintraege = 0;
        Tabzeile[] tabzeileArray = Tabzeile.OBEN;
        int n = Tabzeile.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z)) {
                Oben eintrag = (Oben)this.eintrag(z);
                mittlererObererZuwachs += eintrag.mittel(spieler);
                ++anzahlObereFreieEintraege;
                augensummeObereFreieEintraege += eintrag.augen;
            }
            ++n2;
        }
        double mittlererUntererZuwachs = 0.0;
        Tabzeile[] tabzeileArray2 = Tabzeile.UNTEN;
        int n3 = Tabzeile.UNTEN.length;
        int n4 = 0;
        while (n4 < n3) {
            Tabzeile z = tabzeileArray2[n4];
            if (spieler.setzbar(z)) {
                mittlererUntererZuwachs += this.eintrag(z).mittel(spieler);
            }
            ++n4;
        }
        Zuwachs zuwachs = new Zuwachs(spieler.gesamt(), mittlererObererZuwachs, augensummeObereFreieEintraege, anzahlObereFreieEintraege, mittlererUntererZuwachs);
        Tabzeile[] tabzeileArray3 = Tabzeile.ALLE;
        int n5 = Tabzeile.ALLE.length;
        n3 = 0;
        while (n3 < n5) {
            Tabzeile z = tabzeileArray3[n3];
            if (spieler.setzbar(z)) {
                this.eintrag(z).tippe(spieler, zuwachs);
            }
            ++n3;
        }
    }

    protected abstract Eintragungen eintragungen();

    boolean erneut(Tabzeile eintrag, Wuerfel w) {
        return this.eintrag(eintrag).erneut(w);
    }

    void errechne(Spieler spieler) {
        Arrays.fill(this.augenhaeufigkeiten, 0);
        this.augensumme = 0;
        Object[] objectArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = objectArray[n2];
            this.augensumme += w.augen();
            int n3 = w.augen() - 1;
            this.augenhaeufigkeiten[n3] = this.augenhaeufigkeiten[n3] + 1;
            ++n2;
        }
        objectArray = Paschaufzaehlung.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Wuerfel pasch = objectArray[n2];
            boolean istPaschVorhanden = false;
            int[] nArray = this.augenhaeufigkeiten;
            int n4 = this.augenhaeufigkeiten.length;
            int n5 = 0;
            while (n5 < n4) {
                int augenhaeufigkeit = nArray[n5];
                istPaschVorhanden = augenhaeufigkeit == ((Paschaufzaehlung)((Object)pasch)).groesse() || istPaschVorhanden;
                ++n5;
            }
            this.paschkarte.put((Paschaufzaehlung)((Object)pasch), istPaschVorhanden);
            ++n2;
        }
        objectArray = Tabzeile.ALLE;
        n = Tabzeile.ALLE.length;
        n2 = 0;
        while (n2 < n) {
            Wuerfel z = objectArray[n2];
            this.eintrag((Tabzeile)((Object)z)).bewerte(spieler);
            ++n2;
        }
    }

    void prognostiziere(Spieler spieler) {
        this.tippe(spieler);
        double max = this.findeMaximum(spieler);
        double min = this.findeMinimum(spieler, max);
        this.gewichte(spieler, min, max);
    }

    class Chance
    extends Unten {
        private static final long serialVersionUID = -3411668587180538841L;
        private double punkte;

        Chance() {
            this.mittel = 5.0 * Kombinatorik.augenzahl(3);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Analyse.this.augensumme;
        }

        @Override
        protected double prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.punkte;
        }

        @Override
        protected void waehle(Spieler spieler) {
            this.punkte = 0.0;
            Wuerfel[] wuerfelArray = Analyse.this.wuerfel;
            int n = Analyse.this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w;
                double m = Kombinatorik.augenzahl((w = wuerfelArray[n2]).augen(), spieler.rest());
                this.neuwurfkarte.put(w, m > (double)w.augen());
                this.punkte += m;
                ++n2;
            }
        }
    }

    protected abstract class Eintrag
    implements Serializable {
        private static final long serialVersionUID = -1491939796847928172L;
        private double wichtung;
        private final Random spielstaerkenunsicherheit = new Random();
        protected final IdentityHashMap<Wuerfel, Boolean> neuwurfkarte = new IdentityHashMap(5);
        protected int wert;
        protected double endsumme;
        protected double mittel;

        protected Eintrag() {
            this.nominiereNeuwurf(true);
        }

        protected abstract void bewerte(Spieler var1);

        protected void nominiereNeuwurf(boolean istNeuwurf) {
            Wuerfel[] wuerfelArray = Analyse.this.wuerfel;
            int n = Analyse.this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                this.neuwurfkarte.put(w, istNeuwurf);
                ++n2;
            }
        }

        protected abstract double prognose(Spieler var1, Zuwachs var2);

        protected abstract void waehle(Spieler var1);

        private double individualzugewinn(double unsicherheit, double prognose) {
            return (2.0 * unsicherheit * this.spielstaerkenunsicherheit.nextDouble() + 1.0 - unsicherheit) * prognose;
        }

        double endsumme() {
            return this.endsumme;
        }

        abstract double endsumme(Spieler var1, Zuwachs var2);

        boolean erneut(Wuerfel w) {
            return this.neuwurfkarte.get(w);
        }

        void gewichte(double wichtung) {
            this.wichtung = wichtung;
        }

        double mittel(Spieler spieler) {
            return this.individualzugewinn(spieler.prognoseunsicherheit(), this.mittel);
        }

        void tippe(Spieler spieler, Zuwachs zuwachs) {
            this.endsumme = this.endsumme(spieler, zuwachs);
            if (spieler.rest() > 0) {
                this.nominiereNeuwurf(false);
                this.waehle(spieler);
                this.endsumme += this.individualzugewinn(spieler.prognoseunsicherheit(), this.prognose(spieler, zuwachs));
            } else {
                this.nominiereNeuwurf(true);
                this.endsumme += (double)this.wert;
            }
        }

        int wert() {
            return this.wert;
        }

        double wichtung() {
            return this.wichtung;
        }
    }

    protected abstract class Eintragungen
    extends HashMap<Tabzeile, Eintrag> {
        private static final long serialVersionUID = 8130365096301351531L;

        protected Eintragungen() {
            super(Tabzeile.ALLE.length, 1.0f);
            this.put(Tabzeile.EINS, new Oben(Index.EINSER));
            this.put(Tabzeile.ZWEI, new Oben(Index.ZWEIER));
            this.put(Tabzeile.DREI, new Oben(Index.DREIER));
            this.put(Tabzeile.VIER, new Oben(Index.VIERER));
            this.put(Tabzeile.FUENF, new Oben(Index.FUENFER));
            this.put(Tabzeile.SECHS, new Oben(Index.SECHSER));
            this.put(Tabzeile.CHANCE, new Chance());
        }
    }

    protected static enum Index {
        EINSER,
        ZWEIER,
        DREIER,
        VIERER,
        FUENFER,
        SECHSER;


        public int augen() {
            return this.ordinal() + 1;
        }

        public int vorkommen(int[] haeufigkeiten) {
            return haeufigkeiten[this.ordinal()];
        }
    }

    class Oben
    extends Eintrag {
        private static final long serialVersionUID = -5829769579272736329L;
        private final int augen;
        private final int ind;

        Oben(Index index) {
            this.ind = index.ordinal();
            this.augen = index.augen();
            this.mittel = (double)this.augen * Kombinatorik.fixgleichenmittel(5, 3);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Analyse.this.augenhaeufigkeiten[this.ind] * this.augen;
        }

        @Override
        protected double prognose(Spieler spieler, Zuwachs zuwachs) {
            double min;
            int n = 5 - Analyse.this.augenhaeufigkeiten[this.ind];
            double punkte = min = (double)(this.augen * Analyse.this.augenhaeufigkeiten[this.ind]);
            int k = 1;
            while (k <= n) {
                double p = Kombinatorik.fixgleichenwahrscheinlichkeit(n, k, spieler.rest());
                double neu = k * this.augen;
                punkte += p * neu;
                ++k;
            }
            return punkte;
        }

        @Override
        protected void waehle(Spieler spieler) {
            Wuerfel[] wuerfelArray = Analyse.this.wuerfel;
            int n = Analyse.this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w;
                this.neuwurfkarte.put(w, (w = wuerfelArray[n2]).augen() != this.augen);
                ++n2;
            }
        }

        @Override
        double endsumme(Spieler spieler, Zuwachs zuwachs) {
            return (double)spieler.endsumme() + zuwachs.zuwachs(spieler.gesamt(), Analyse.this.augenhaeufigkeiten[this.ind], spieler.rest(), this.augen) - this.mittel(spieler);
        }
    }

    public abstract class Pasch
    extends Unten {
        private static final long serialVersionUID = 8666151619656864766L;
        private final int paschgroesse;
        private int paschaugenzahl;

        protected Pasch(int paschgroesse) {
            this.paschgroesse = paschgroesse;
            this.mittel = this.augensumme(3);
        }

        private double augensumme(int r) {
            if (r > 0) {
                double augensumme = Kombinatorik.gleichenwahrscheinlichkeit(1) * this.augensumme(r - 1);
                int k = 2;
                while (k < this.paschgroesse) {
                    int a = 1;
                    while (a <= 6) {
                        augensumme += Kombinatorik.mehrlingswahrscheinlichkeit(a, k) * this.augensumme(a, r - 1, k);
                        ++a;
                    }
                    ++k;
                }
                return augensumme += (3.5 * (double)this.paschgroesse + (double)(5 - this.paschgroesse) * Kombinatorik.augenzahl(r)) * Kombinatorik.mindestgleichenwahrscheinlichkeit(this.paschgroesse);
            }
            return 0.0;
        }

        private double prognose(int augen, int r, int max) {
            double punkte = 0.0;
            if (max < this.paschgroesse) {
                punkte = max > 1 ? this.augensumme(augen, r, max) : this.augensumme(r);
            } else {
                Wuerfel[] wuerfelArray = Analyse.this.wuerfel;
                int n = Analyse.this.wuerfel.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel w = wuerfelArray[n2];
                    punkte = ((Boolean)this.neuwurfkarte.get(w)).booleanValue() ? (punkte += Kombinatorik.augenzahl(r)) : (punkte += (double)w.augen());
                    ++n2;
                }
            }
            return punkte;
        }

        protected abstract double augensumme(int var1, int var2, int var3);

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = this.pasch() ? Analyse.this.augensumme : 0;
        }

        protected abstract boolean pasch();

        @Override
        protected double prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.prognose(this.paschaugenzahl, spieler.rest(), this.paschlaenge());
        }

        @Override
        protected void waehle(Spieler spieler) {
            this.paschaugenzahl = 6;
            while (Analyse.this.augenhaeufigkeiten[this.paschaugenzahl - 1] < this.paschlaenge()) {
                --this.paschaugenzahl;
            }
            int haeufigkeit = 0;
            Wuerfel[] wuerfelArray = Analyse.this.wuerfel;
            int n = Analyse.this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                if (w.augen() == this.paschaugenzahl) {
                    this.neuwurfkarte.put(w, ++haeufigkeit > this.paschgroesse && Kombinatorik.augenzahl(spieler.rest()) > (double)w.augen());
                } else {
                    this.neuwurfkarte.put(w, !this.pasch() || Kombinatorik.augenzahl(spieler.rest()) > (double)w.augen());
                }
                ++n2;
            }
        }
    }

    protected static enum Paschaufzaehlung {
        ZWEIERPASCH,
        DREIERPASCH,
        VIERERPASCH,
        FUENFERPASCH;


        public int groesse() {
            return this.ordinal() + 2;
        }
    }

    public abstract class Unten
    extends Eintrag {
        private static final long serialVersionUID = 8894740065051562154L;

        protected int paschlaenge() {
            int max = 1;
            for (Map.Entry<Paschaufzaehlung, Boolean> pasch : Analyse.this.paschkarte.entrySet()) {
                int groesse = pasch.getKey().groesse();
                boolean istPaschVorhanden = pasch.getValue();
                if (!istPaschVorhanden || groesse <= max) continue;
                max = groesse;
            }
            return max;
        }

        @Override
        double endsumme(Spieler spieler, Zuwachs zuwachs) {
            return (double)spieler.endsumme() + zuwachs.zuwachs() - this.mittel(spieler);
        }
    }

    protected static class Zuwachs {
        private final double mittlererBonusZuwachs;
        private final double mittlererZuwachs;
        private final double p;
        private final int teilung;

        Zuwachs(int gesamt, double mittlererObererZuwachs, int augensummeObereFreieEintraege, int anzahlFreieObereEintraege, double mittlererUntererZuwachs) {
            if (gesamt < 63 && augensummeObereFreieEintraege > 0) {
                this.teilung = (63 - gesamt + augensummeObereFreieEintraege - 1) / augensummeObereFreieEintraege;
                double q = Kombinatorik.mindestfixgleichenwahrscheinlichkeit(this.teilung);
                this.mittlererBonusZuwachs = Math.pow(q, anzahlFreieObereEintraege) * 35.0;
                this.p = q != 0.0 ? q : 1.0;
            } else {
                this.teilung = 0;
                this.p = 1.0;
                this.mittlererBonusZuwachs = 0.0;
            }
            this.mittlererZuwachs = mittlererObererZuwachs + mittlererUntererZuwachs;
        }

        double zuwachs() {
            return this.mittlererZuwachs + this.mittlererBonusZuwachs;
        }

        double zuwachs(int gesamt, int guenstige, int r, int augen) {
            double q = 0.0;
            int punkteBisZumBonus = 63 - gesamt;
            if (punkteBisZumBonus > 0) {
                q = 1.0;
                if ((punkteBisZumBonus -= guenstige * augen) > 0) {
                    int n = 5 - guenstige;
                    int min = guenstige <= this.teilung ? this.teilung - guenstige : 0;
                    q = Kombinatorik.mindestfixgleichenwahrscheinlichkeit(n, min, r);
                }
            }
            return this.mittlererZuwachs + q / this.p * this.mittlererBonusZuwachs;
        }
    }
}

