/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Ressource;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Signal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class Hilfe
extends JDialog
implements PropertyChangeListener,
HyperlinkListener {
    private static final int BREITE = 600;
    private static final int HOEHE = 400;
    private static final String INDEX = "index.html";
    private static final URL STARTSEITE = Ressource.ANLEITUNG.url("index.html");
    private URL seite = STARTSEITE;
    private final JEditorPane browser = new JEditorPane();
    private final Stack<URL> history = new Stack();
    private final JPanel hilfe = new JPanel(new BorderLayout(8, 8));
    private final JPanel kontrollen = new JPanel(new GridLayout(1, 0, 4, 2));
    private final JButton inhalt = new JButton("Zum Hilfebeginn");
    private final JButton zurueck = new JButton("Schritt zur\u00fcck");
    private final JButton beenden = new JButton("Hilfe beenden");

    Hilfe() throws Exception {
        this.setTitle("JaFuffy (Hilfe)");
        this.setIconImages(Oberflaeche.LOGOS);
        UIManager.addPropertyChangeListener(this);
        this.browser.setPage(this.seite);
        this.kontrollen.add(this.inhalt);
        this.inhalt.setEnabled(false);
        this.kontrollen.add(this.zurueck);
        this.zurueck.setEnabled(false);
        this.kontrollen.add(this.beenden);
        this.browser.setEditable(false);
        this.browser.addHyperlinkListener(this);
        this.inhalt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hilfe.this.history.push(Hilfe.this.seite);
                    Hilfe.this.seite = STARTSEITE;
                    Hilfe.this.browser.setPage(Hilfe.this.seite);
                    Hilfe.this.inhalt.setEnabled(false);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        });
        this.zurueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hilfe.this.seite = (URL)Hilfe.this.history.pop();
                    Hilfe.this.browser.setPage(Hilfe.this.seite);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    Signal.WARNUNG.play();
                    JOptionPane.showMessageDialog(Hilfe.this, "Hilfe-Datei nicht gefunden!", "JaFuffy (Warnung)", 2);
                }
                Hilfe.this.zurueck.setEnabled(!Hilfe.this.history.empty());
                Hilfe.this.inhalt.setEnabled(Hilfe.this.seite != STARTSEITE);
            }
        });
        this.beenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hilfe.this.setVisible(false);
            }
        });
        this.hilfe.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JScrollPane scrollPane = new JScrollPane(this.browser);
        scrollPane.setPreferredSize(new Dimension(600, 400));
        this.hilfe.add((Component)scrollPane, "Center");
        this.hilfe.add((Component)this.kontrollen, "South");
        this.getRootPane().setDefaultButton(this.beenden);
        this.setContentPane(this.hilfe);
        this.pack();
        this.beenden.requestFocus();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.history.push(this.seite);
                this.seite = he.getURL();
                this.browser.setPage(this.seite);
                this.zurueck.setEnabled(true);
                this.inhalt.setEnabled(this.seite != STARTSEITE);
            }
            catch (Exception e) {
                e.printStackTrace();
                Signal.WARNUNG.play();
                JOptionPane.showMessageDialog(this, "Kann die folgende Seite nicht \u00f6ffnen:\n" + this.seite.toString() + "\nGrund:\n" + e.toString() + "\n\nHinweis:\n" + "JaFuffy darf als Applet nicht auf externe Seiten zugreifen.", "JaFuffy (Warnung)", 2);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }
}

