/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.logik.Statistik;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class Verlaufstabelle
extends JTable {
    private static final int ZWISCHENRAUM = 8;

    Verlaufstabelle(Statistik statistik) {
        this.getTableHeader().setDefaultRenderer(new Kopf());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        this.setRowSelectionAllowed(false);
        this.setToolTipText("Die Tabelle ist sortierbar durch Anklicken der Spaltenk\u00f6pfe");
        this.setModel(new Adapter(statistik));
    }

    @Override
    public TableCellRenderer getCellRenderer(int zeile, int spalte) {
        if (spalte > 0) {
            return super.getCellRenderer(zeile, spalte);
        }
        return new Nummer();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int zeile, int spalte) {
        DefaultTableCellRenderer zelle = (DefaultTableCellRenderer)super.prepareRenderer(renderer, zeile, spalte);
        zelle.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        return zelle;
    }

    private void springe(final int zeile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Verlaufstabelle.this.scrollRectToVisible(Verlaufstabelle.this.getCellRect(Verlaufstabelle.this.getRowSorter().convertRowIndexToView(zeile), 0, true));
            }
        });
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent event) {
                int geometrischerIndex = this.columnModel.getColumnIndexAtX(event.getPoint().x);
                int logischerIndex = this.columnModel.getColumn(geometrischerIndex).getModelIndex();
                return logischerIndex == 0 ? "Laufende Nummern des Spiels im Turniers" : "Endsummen f\u00fcr den genannten Spieler zu Spielen mit den laufenden Nummern";
            }
        };
    }

    void aktualisiere() {
        Adapter adapter = (Adapter)this.getModel();
        int zeile = adapter.getRowCount() - 1;
        adapter.fireTableRowsUpdated(zeile, zeile);
    }

    void beende() {
        Adapter adapter = (Adapter)this.getModel();
        int zeile = adapter.getRowCount() - 1;
        adapter.fireTableRowsInserted(zeile, zeile);
        this.springe(zeile);
    }

    void starte() {
        Adapter adapter = (Adapter)this.getModel();
        adapter.fireTableStructureChanged();
        int zeile = adapter.getRowCount() - 1;
        this.springe(zeile);
    }

    private static class Adapter
    extends AbstractTableModel {
        private final Statistik statistik;

        Adapter(Statistik statistik) {
            this.statistik = statistik;
        }

        @Override
        public Class<?> getColumnClass(int spalte) {
            return Integer.class;
        }

        @Override
        public int getColumnCount() {
            return this.verlauf() != null ? 1 + this.verlauf().length : 1;
        }

        @Override
        public String getColumnName(int spalte) {
            if (spalte > 0) {
                return this.statistik.spieler().get(spalte - 1).toString();
            }
            return "Nummer";
        }

        @Override
        public int getRowCount() {
            return this.verlauf() != null ? this.verlauf()[0].size() : 0;
        }

        @Override
        public Object getValueAt(int zeile, int spalte) {
            if (spalte > 0) {
                return this.verlauf()[spalte - 1].get(zeile);
            }
            return zeile + 1;
        }

        ArrayList<Integer>[] verlauf() {
            return this.statistik.verlauf();
        }
    }

    private static class Kopf
    extends JLabel
    implements TableCellRenderer {
        private final Color schriftfarbe = this.getForeground();

        Kopf() {
            this.setHorizontalAlignment(4);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
        }

        @Override
        public Component getTableCellRendererComponent(JTable tabelle, Object wert, boolean selektiert, boolean fokussiert, int zeile, int spalte) {
            if (spalte > 0) {
                this.setFont(this.getFont().deriveFont(0));
                this.setForeground(this.schriftfarbe);
            } else {
                this.setFont(this.getFont().deriveFont(2));
                this.setForeground(Color.GRAY);
            }
            this.setText("<html>" + this.sortierrichtung(tabelle, spalte) + wert.toString() + "</html>");
            return this;
        }

        private String sortierrichtung(JTable tabelle, int spalte) {
            List<RowSorter.SortKey> sortierschluessel = tabelle.getRowSorter().getSortKeys();
            if (sortierschluessel.isEmpty() || sortierschluessel.get(0).getColumn() != spalte) {
                return "";
            }
            switch (sortierschluessel.get(0).getSortOrder()) {
                case ASCENDING: {
                    return "&uarr;";
                }
                case DESCENDING: {
                    return "&darr;";
                }
            }
            return "";
        }
    }

    private static class Nummer
    extends DefaultTableCellRenderer {
        Nummer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont(2));
            this.setForeground(Color.GRAY);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tabelle, Object wert, boolean selektiert, boolean fokussiert, int zeile, int spalte) {
            this.setText(wert.toString());
            return this;
        }
    }
}

