/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Geraeusch;
import jafuffy.bedienung.Grafik;
import jafuffy.logik.Wuerfel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wuerfelbild
extends JToggleButton {
    private static final int RAND = 4;
    private static final int DELAY = 80;
    private static final String WUERFEL = "Wuerfel";
    private static final ImageIcon[] BILDER = new ImageIcon[6];
    private static final ImageIcon[] BILDER_S = new ImageIcon[6];
    private static final Geraeusch LEERUNG;
    private static final Geraeusch FUELLUNG;
    private final int taste;

    static {
        int i = 0;
        while (i < 6) {
            Wuerfelbild.BILDER[i] = Grafik.icon(WUERFEL + (i + 1) + ".gif");
            Wuerfelbild.BILDER_S[i] = Grafik.icon(WUERFEL + (i + 1) + "s.gif");
            ++i;
        }
        LEERUNG = new Geraeusch("Leerung.wav");
        FUELLUNG = new Geraeusch("Fuellung.wav");
    }

    Wuerfelbild(int position) {
        this.taste = position + 1;
        this.setFocusable(false);
        this.setMargin(new Insets(4, 4, 4, 4));
        this.setHorizontalAlignment(0);
        this.setEnabled(false);
        this.setIcon(BILDER[0]);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(49 + position, 0), this);
        this.getActionMap().put(this, new AbstractAction(){
            private static final int KLICKZEIT = 100;

            @Override
            public void actionPerformed(ActionEvent ev) {
                JToggleButton button = (JToggleButton)ev.getSource();
                button.doClick(100);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Wuerfelbild.this.aktualisiere();
                Wuerfel wuerfel = Wuerfelbild.this.modell();
                if (wuerfel.isPressed()) {
                    if (wuerfel.isSelected()) {
                        FUELLUNG.play(80);
                    } else {
                        LEERUNG.play(80);
                    }
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setToolTipText(enabled ? "<html>Angew\u00e4hlte W\u00fcrfel liegen im Becher<br><small>Mausklick oder Taste \"" + this.taste + "\"" + "<html>" : "Bitte in der Tabelle setzen!");
        this.setBorderPainted(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setModel(ButtonModel modell) {
        super.setModel(modell);
        if (modell instanceof Wuerfel) {
            this.aktualisiere();
        }
    }

    private void aktualisiere() {
        this.setIcon(BILDER[this.augen() - 1]);
        this.setSelectedIcon(BILDER_S[this.augen() - 1]);
        this.setDisabledIcon(BILDER[this.augen() - 1]);
    }

    private int augen() {
        return this.modell().augen();
    }

    Wuerfel modell() {
        return (Wuerfel)this.getModel();
    }
}

