/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Ressource;
import jafuffy.Vorbelegung;
import jafuffy.logik.Beginner;
import jafuffy.logik.Variante;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Eigenschaften
extends Properties {
    public static final Eigenschaften GLOBAL;
    private static final String HINWEIS = "JaFuffy-Einstellungen (bitte nicht von Hand \u00e4ndern)";
    private static final String INI = "JaFuffy.ini";
    private static final Vorbelegung VORBELEGUNG;
    private File datei;

    static {
        Eigenschaften global;
        VORBELEGUNG = new Vorbelegung(Ressource.soundsystem());
        SecurityManager sicherheit = System.getSecurityManager();
        if (sicherheit == null) {
            String pfad = String.valueOf(System.getProperty("user.home")) + File.separator + INI;
            global = new Eigenschaften(new File(pfad));
        } else {
            try {
                sicherheit.checkPropertyAccess("user.home");
                String pfad = String.valueOf(System.getProperty("user.home")) + File.separator + INI;
                sicherheit.checkRead(pfad);
                sicherheit.checkWrite(pfad);
                global = new Eigenschaften(new File(pfad));
            }
            catch (SecurityException e) {
                global = new Eigenschaften();
            }
        }
        GLOBAL = global;
    }

    private Eigenschaften() {
        super(VORBELEGUNG);
    }

    private Eigenschaften(File datei) {
        super(VORBELEGUNG);
        if (datei.exists()) {
            try {
                FileInputStream reader = new FileInputStream(datei);
                this.load(reader);
                reader.close();
            }
            catch (IOException exeption) {
                exeption.printStackTrace();
            }
        }
        this.datei = datei;
    }

    public boolean aktiv(String schluessel) {
        return this.getProperty(schluessel).equals(Status.AKTIV.name());
    }

    public int beginnmodus() {
        return Beginner.valueOf(this.getProperty("Beginnmodus")).ordinal();
    }

    public File datei(String name) {
        return new File(this.getProperty("Pfad"), name);
    }

    public boolean erststart() {
        return this.getProperty("Starts").equals("0");
    }

    public boolean kaltstart() {
        return this.getProperty("Neustart").equals("kalt");
    }

    public void merkeNeustartAnforderung(boolean warm) {
        this.setProperty("Neustart", warm ? "warm" : "kalt");
    }

    public boolean neustart() {
        return this.kaltstart() || this.warmstart();
    }

    public String pfad() {
        return this.getProperty("Pfad");
    }

    public void pfad(String pfad) {
        this.setProperty("Pfad", pfad);
    }

    public void quittiereNeustartAnforderung() {
        this.setProperty("Neustart", Status.PASSIV.name());
    }

    public void speichere(int x, int y, int b, int h) throws IOException {
        this.setProperty("X", String.valueOf(x));
        this.setProperty("Y", String.valueOf(y));
        this.setProperty("Breite", String.valueOf(b));
        this.setProperty("Hoehe", String.valueOf(h));
        this.setProperty("Starts", String.valueOf(Integer.parseInt(this.getProperty("Starts")) + 1));
        FileOutputStream writer = new FileOutputStream(this.datei);
        this.store(writer, HINWEIS);
        writer.close();
    }

    public int variante() {
        return Variante.valueOf(this.getProperty("Variante")).ordinal();
    }

    public boolean warmstart() {
        return this.getProperty("Neustart").equals("warm");
    }

    public void wechsle(String schluessel) {
        this.setProperty(schluessel, this.aktiv(schluessel) ? Status.PASSIV.name() : Status.AKTIV.name());
    }

    public static enum Status {
        PASSIV,
        AKTIV;

    }
}

