/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.Range;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.interaction.Chart3DMouseEvent;
import com.orsoncharts.interaction.Chart3DMouseListener;
import com.orsoncharts.label.CategoryItemLabelGenerator;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.table.RectanglePainter;
import com.orsoncharts.table.StandardRectanglePainter;
import jafuffy.bedienung.Report;
import jafuffy.logik.Statistik;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class Verlaufsgrafik
extends JPanel {
    private static final double ZLAENGE = 0.8;
    private static final double XLAENGE = 0.5;
    private static final Offset2D VERSCHIEBUNG = new Offset2D(0.0, -15.0);
    private static final Range WERTEBEREICH = new Range(0.0, 350.0);
    private static final int RHO = 25;
    private static final ViewPoint3D PERSPEKTIVE = ViewPoint3D.createAboveViewPoint((double)25.0);
    private static final int PROJEKTIONSDISTANZ = 2000;
    private static final BasicStroke GITTERLINIENSTIL;
    private static final Color WANDFARBE;
    private static final Color ZAHLSCHRIFTFARBE;
    private static final Color ACHSSCHRIFTFARBE;
    private static final Font ZAHLSCHRIFTART;
    private static final Font ACHSSCHRIFTART;
    private DisplayPanel3D display;

    static {
        PERSPEKTIVE.panLeftRight(0.2617993877991494);
        PERSPEKTIVE.moveUpDown(-0.10471975511965977);
        PERSPEKTIVE.roll(0.1308996938995747);
        GITTERLINIENSTIL = new BasicStroke(0.25f);
        WANDFARBE = new Color(176, 192, 192, 64);
        ZAHLSCHRIFTFARBE = Color.GRAY;
        ACHSSCHRIFTFARBE = Color.LIGHT_GRAY;
        ZAHLSCHRIFTART = new Font("SansSerif", 0, 12);
        ACHSSCHRIFTART = new Font("SansSerif", 1, 12);
    }

    Verlaufsgrafik() {
        super(new BorderLayout());
    }

    void starte(Statistik statistik) {
        if (this.display != null) {
            this.remove((Component)this.display);
        }
        final Chart3D chart = Chart3DFactory.createBarChart(null, null, statistik.datensatz(), null, (String)"Spielnummer", (String)"Punktzahl");
        chart.setAntiAlias(true);
        chart.setLegendBuilder(null);
        chart.setChartBoxColor(WANDFARBE);
        chart.setProjDistance(2000.0);
        chart.setViewPoint(new ViewPoint3D(PERSPEKTIVE.getPoint(), PERSPEKTIVE.calcRollAngle()));
        chart.setTranslate2D(VERSCHIEBUNG);
        chart.setBackground((RectanglePainter)new StandardRectanglePainter((Paint)Report.HINTERGRUNDFARBE));
        final Chart3DPanel panel = new Chart3DPanel(chart);
        panel.addChartMouseListener(new Chart3DMouseListener(){

            public void chartMouseMoved(Chart3DMouseEvent event) {
            }

            public void chartMouseClicked(Chart3DMouseEvent event) {
                if (event.getTrigger().getClickCount() > 1) {
                    chart.setViewPoint(new ViewPoint3D(PERSPEKTIVE.getPoint(), PERSPEKTIVE.calcRollAngle()));
                    chart.setTranslate2D(VERSCHIEBUNG);
                    panel.zoomToFit();
                }
            }
        });
        this.display = new DisplayPanel3D((Panel3D)panel, true, false);
        CategoryPlot3D plot = (CategoryPlot3D)chart.getPlot();
        plot.getRowAxis().setVisible(false);
        plot.setGridlineStrokeForValues((Stroke)GITTERLINIENSTIL);
        plot.setToolTipGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("<html><strong>%1$s</strong> hat im %3$d. Spiel <strong>%4$.0f Punkte</strong> erzielt.</html>"));
        StandardCategoryAxis3D turnierachse = (StandardCategoryAxis3D)plot.getColumnAxis();
        turnierachse.setLabelFont(ACHSSCHRIFTART);
        turnierachse.setLabelColor(ACHSSCHRIFTFARBE);
        turnierachse.setTickLabelFont(ZAHLSCHRIFTART);
        turnierachse.setTickLabelColor(ZAHLSCHRIFTFARBE);
        NumberAxis3D punktzahlachse = (NumberAxis3D)plot.getValueAxis();
        punktzahlachse.setLabelFont(ACHSSCHRIFTART);
        punktzahlachse.setLabelColor(ACHSSCHRIFTFARBE);
        punktzahlachse.setTickLabelFont(ZAHLSCHRIFTART);
        punktzahlachse.setTickLabelColor(ZAHLSCHRIFTFARBE);
        punktzahlachse.setAutoRangeIncludeZero(true);
        punktzahlachse.setAutoRangeStickyZero(true);
        punktzahlachse.setRange(WERTEBEREICH);
        plot.setValueAxis((ValueAxis3D)punktzahlachse);
        BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
        renderer.setColors(Report.BALKENFARBEN);
        renderer.setTopColorSource((CategoryColorSource)new StandardCategoryColorSource(new Color[]{Color.YELLOW}));
        renderer.setBarXWidth(0.5);
        renderer.setBarZWidth(0.8);
        this.add((Component)this.display);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.zoomToFit();
            }
        });
    }
}

