/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.AbstractDataset3D;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.Series3DChangeEvent;
import com.orsoncharts.data.Series3DChangeListener;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYZSeriesCollection<S extends Comparable<S>>
extends AbstractDataset3D
implements XYZDataset<S>,
Series3DChangeListener,
Serializable {
    private final List<XYZSeries<S>> series = new ArrayList<XYZSeries<S>>();

    @Override
    public int getSeriesCount() {
        return this.series.size();
    }

    @Override
    public int getSeriesIndex(S key) {
        ArgChecks.nullNotPermitted(key, "key");
        return this.getSeriesKeys().indexOf(key);
    }

    @Override
    public List<S> getSeriesKeys() {
        ArrayList<S> result = new ArrayList<S>();
        for (XYZSeries<S> s : this.series) {
            result.add(s.getKey());
        }
        return result;
    }

    @Override
    public S getSeriesKey(int seriesIndex) {
        return this.getSeries(seriesIndex).getKey();
    }

    public void add(XYZSeries<S> series) {
        ArgChecks.nullNotPermitted(series, "series");
        if (this.getSeriesIndex(series.getKey()) >= 0) {
            throw new IllegalArgumentException("Another series with the same key already exists within the collection.");
        }
        this.series.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void remove(int seriesIndex) {
        XYZSeries<S> s = this.getSeries(seriesIndex);
        this.remove(s);
    }

    public void remove(XYZSeries series) {
        ArgChecks.nullNotPermitted(series, "series");
        if (this.series.contains(series)) {
            series.removeChangeListener(this);
            this.series.remove(series);
            this.fireDatasetChanged();
        }
    }

    public void removeAll() {
        if (!this.series.isEmpty()) {
            for (XYZSeries<S> s : this.series) {
                s.removeChangeListener(this);
            }
            this.series.clear();
            this.fireDatasetChanged();
        }
    }

    public XYZSeries<S> getSeries(int index) {
        ArgChecks.checkArrayBounds(index, "index", this.series.size());
        return this.series.get(index);
    }

    public XYZSeries getSeries(Comparable<?> key) {
        ArgChecks.nullNotPermitted(key, "key");
        for (XYZSeries<S> s : this.series) {
            if (!s.getKey().equals(key)) continue;
            return s;
        }
        return null;
    }

    @Override
    public int getItemCount(int seriesIndex) {
        XYZSeries<S> s = this.series.get(seriesIndex);
        return s.getItemCount();
    }

    @Override
    public double getX(int seriesIndex, int itemIndex) {
        XYZSeries<S> s = this.series.get(seriesIndex);
        return s.getXValue(itemIndex);
    }

    @Override
    public double getY(int seriesIndex, int itemIndex) {
        XYZSeries<S> s = this.series.get(seriesIndex);
        return s.getYValue(itemIndex);
    }

    @Override
    public double getZ(int seriesIndex, int itemIndex) {
        XYZSeries<S> s = this.series.get(seriesIndex);
        return s.getZValue(itemIndex);
    }

    @Override
    public void seriesChanged(Series3DChangeEvent event) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZSeriesCollection)) {
            return false;
        }
        XYZSeriesCollection that = (XYZSeriesCollection)obj;
        return this.series.equals(that.series);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + ObjectUtils.hashCode(this.series);
        return hash;
    }

    public String toString() {
        return JSONUtils.writeXYZDataset(this);
    }
}

