/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Eigenschaften;
import jafuffy.JaFuffyDialoge;
import jafuffy.Ressource;
import jafuffy.bedienung.Ende;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Signal;
import jafuffy.bedienung.Willkommen;
import jafuffy.logik.Manager;
import jafuffy.logik.Statistik;
import jafuffy.logik.Update;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class JaFuffy {
    private static final String MINDEST_LANG_VERSION = "1.7";
    private static final String MINDEST_SWING_VERSION = "1.7";
    private static final String VERRIEGELUNGSDATEI = "JaFuffy.lock";

    public static void main(String[] args) {
        Eigenschaften eigenschaften;
        Oberflaeche.starteJetzt(new Runnable(){

            @Override
            public void run() {
                JaFuffy.pruefeKompatibilitaet();
            }
        });
        JaFuffy.werteArgumenteAus(args);
        try {
            if (JaFuffy.mehrfachstart()) {
                JaFuffyDialoge.meldeMehrfachstart();
                System.exit(0);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if ((eigenschaften = Eigenschaften.GLOBAL).erststart()) {
            Willkommen willkommen = new Willkommen(eigenschaften);
            willkommen.dispose();
            if (willkommen.abgebrochen()) {
                System.exit(0);
            }
        }
        JaFuffy.registriereAufraeumer(eigenschaften);
        new JaFuffy(eigenschaften, JaFuffy.beschaffeStatistik());
    }

    private static Statistik beschaffeStatistik() {
        try {
            File datei = Eigenschaften.GLOBAL.datei("Statistik.obj");
            if (datei.exists()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(datei));
                    Statistik statistik = (Statistik)ois.readObject();
                    ois.close();
                    return statistik;
                }
                catch (IOException | ClassNotFoundException exception) {
                    exception.printStackTrace();
                    Signal.ALARM.play();
                    JaFuffyDialoge.meldeFehlendeStatistikdaten(exception);
                }
            }
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen verbieten persistente Statistik: " + exception);
        }
        return new Statistik();
    }

    private static boolean mehrfachstart() throws IOException {
        String tmpdir;
        try {
            tmpdir = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException exception) {
            System.out.println("Per Java Web Start ausgef\u00fchrt (Heuristik): " + exception);
            return false;
        }
        final File datei = new File(tmpdir, VERRIEGELUNGSDATEI);
        final RandomAccessFile stream = new RandomAccessFile(datei, "rw");
        FileChannel kanal = stream.getChannel();
        FileLock riegel = kanal.tryLock();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    stream.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                datei.delete();
            }
        });
        return riegel == null;
    }

    private static void pruefeKompatibilitaet() {
        Package lang = Package.getPackage("java.lang");
        Package swing = Package.getPackage("javax.swing");
        if (!lang.isCompatibleWith("1.7") || !swing.isCompatibleWith("1.7")) {
            JaFuffyDialoge.meldeVersionsproblem(lang, "1.7", swing, "1.7");
        }
    }

    private static void registriereAufraeumer(final Eigenschaften eigenschaften) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (eigenschaften.neustart()) {
                        try {
                            File jar = new File(JaFuffy.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                            try {
                                String java = String.valueOf(System.getProperty("java.home")) + "/bin/java";
                                StringBuffer cmd = new StringBuffer("\"" + java + "\"");
                                cmd.append(" -jar \"").append(jar.getPath()).append("\"");
                                Runtime.getRuntime().exec(cmd.toString());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (URISyntaxException exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (SecurityException exception) {
            System.out.println("Sicherheitseinstellungen verbieten automatischen Neustart: " + exception);
        }
    }

    private static void werteArgumenteAus(String[] args) {
        if (args.length > 1) {
            System.err.println("Maximal ein Argument erlaubt!");
        }
        if (args.length == 1) {
            if (args[0].equals("nosound")) {
                Ressource.schalteStumm();
                System.out.println("Sound ist abgeschaltet");
            } else {
                System.err.println("Option nicht bekannt!");
            }
        }
    }

    public JaFuffy(final Eigenschaften eigenschaften, final Statistik statistik) {
        Oberflaeche.starteSpaeter(new Runnable(){

            @Override
            public void run() {
                Fenster fenster = new Fenster("JaFuffy");
                Ende ende = new Ende(eigenschaften, statistik);
                fenster.addWindowListener(ende);
                Update update = new Update();
                new Manager(eigenschaften, statistik, fenster, ende, update);
                update.ueberpruefe(eigenschaften.aktiv("Nachschauen"), fenster);
            }
        });
    }
}

