/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Verlaufsgrafik;
import jafuffy.bedienung.Verlaufstabelle;
import jafuffy.bedienung.Zwischenstand;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEStatistik;
import jafuffy.logik.Statistik;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Report
extends JDialog
implements PropertyChangeListener,
ChangeListener {
    private static final int BREITE = 600;
    private static final int HOEHE = 580;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final Border RAHMEN = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
    static final Color HINTERGRUNDFARBE = new Color(250, 252, 250);
    static final Color[] BALKENFARBEN = new Color[]{Color.MAGENTA.darker(), Color.GREEN.darker(), Color.ORANGE.darker(), Color.CYAN.darker()};
    private final JPanel legende = new JPanel(new GridLayout(0, 1, 0, 8));
    private final Verlaufsgrafik verlaufsgrafik;
    private final Verlaufstabelle verlaufstabelle;
    private final Zwischenstand zwischenstand;

    public Report(Statistik statistik) {
        UIManager.addPropertyChangeListener(this);
        this.zwischenstand = new Zwischenstand();
        this.verlaufsgrafik = new Verlaufsgrafik();
        this.verlaufsgrafik.setBorder(RAHMEN);
        this.verlaufstabelle = new Verlaufstabelle();
        JScrollPane zwischenstandscrolling = new JScrollPane(this.zwischenstand);
        zwischenstandscrolling.setBorder(RAHMEN);
        JTabbedPane kartei = new JTabbedPane();
        kartei.addTab("Balkendiagramm zum Verlauf", this.verlaufsgrafik);
        kartei.addTab("Tabellenauflistung des Verlaufs", this.verlaufstabellenfeld());
        kartei.setToolTipTextAt(0, "<html><p>Rotieren mittels Maus-Drag.</p><p>Zoomen mittels Mausrad.</p><p>Verschieben mittels mittlerer Maustaste oder Maus-Drag mit Alt-Taste.</p><p>Doppelklick stellt Standardansicht wieder her.</p></html>");
        kartei.setToolTipTextAt(1, "<html><p>Sortieren durch Anklicken der Spaltenk\u00f6pfe</p></html>");
        this.setContentPane(this.feld(zwischenstandscrolling, kartei));
        this.setIconImages(Oberflaeche.LOGOS);
        this.setPreferredSize(new Dimension(600, 580));
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Statistik statistik = (Statistik)ce.getSource();
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEStatistik)((Object)cej.ereignis())) {
                case TURNIER_START: 
                case TURNIER_WEITER: {
                    this.starte(statistik);
                    this.zwischenstand.starte(statistik);
                    this.verlaufsgrafik.starte(statistik);
                    this.verlaufstabelle.starte(statistik);
                    this.revalidate();
                    break;
                }
                case SPIEL_ENDE: {
                    this.verlaufstabelle.beende();
                    break;
                }
                case STAND: {
                    this.zwischenstand.aktualisiere(statistik);
                    this.verlaufstabelle.aktualisiere();
                    break;
                }
            }
            this.setTitle("JaFuffy (Report: " + statistik.titel() + ")");
            this.repaint();
        }
    }

    private JPanel feld(JScrollPane zwischenstandscrolling, JTabbedPane kartei) {
        JPanel feld = new JPanel(new BorderLayout(0, 4));
        feld.add((Component)zwischenstandscrolling, "First");
        feld.add((Component)kartei, "Center");
        feld.add((Component)this.leiste(), "Last");
        feld.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return feld;
    }

    private JPanel leiste() {
        JButton schliessen = new JButton("Report schlie\u00dfen");
        schliessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Report.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(schliessen);
        JButton zeigen = new JButton("Legende zeigen");
        zeigen.setToolTipText("Zeigt die Zuordnung von Farben zu Spielern");
        zeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(Report.this, Report.this.legende, "JaFuffy (Legende)", 1);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(schliessen);
        leiste.add(zeigen);
        return leiste;
    }

    private void starte(Statistik statistik) {
        this.legende.removeAll();
        int i = 0;
        while (i < statistik.teilnehmer().size()) {
            JLabel name = new JLabel(statistik.teilnehmer().get(i).toString(), 0);
            this.legende.add(name);
            name.setOpaque(true);
            name.setForeground(BALKENFARBEN[i]);
            name.setBackground(Color.white);
            name.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BALKENFARBEN[i], 2), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
            ++i;
        }
    }

    private JPanel verlaufstabellenfeld() {
        final JPanel verlaufstabellenfeld = new JPanel(new FlowLayout());
        verlaufstabellenfeld.setBorder(BorderFactory.createCompoundBorder(RAHMEN, BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        verlaufstabellenfeld.setBackground(HINTERGRUNDFARBE);
        JScrollPane verlaufstabellenscrolling = new JScrollPane(this.verlaufstabelle){

            @Override
            public Dimension getPreferredSize() {
                Insets rand = this.getInsets();
                Insets verlaufstabellenfeldrand = verlaufstabellenfeld.getInsets();
                Dimension verlaufstabellengroesse = Report.this.verlaufstabelle.getPreferredSize();
                Dimension verlaufstabellenfeldgroesse = verlaufstabellenfeld.getSize();
                return new Dimension(verlaufstabellengroesse.width + this.getVerticalScrollBar().getWidth() + rand.left + rand.right, verlaufstabellenfeldgroesse.height - verlaufstabellenfeldrand.top - verlaufstabellenfeldrand.bottom - rand.top - 1 - rand.bottom - 1);
            }
        };
        verlaufstabellenscrolling.setVerticalScrollBarPolicy(22);
        verlaufstabellenscrolling.setBorder(BorderFactory.createLoweredBevelBorder());
        verlaufstabellenfeld.add(verlaufstabellenscrolling);
        return verlaufstabellenfeld;
    }
}

