/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

public enum Tabzeile {
    EINS("1er", "nur Einser z\u00e4hlen", Art.OBEN),
    ZWEI("2er", "nur Zweier z\u00e4hlen", Art.OBEN),
    DREI("3er", "nur Dreier z\u00e4hlen", Art.OBEN),
    VIER("4er", "nur Vierer z\u00e4hlen", Art.OBEN),
    FUENF("5er", "nur F\u00fcnfer z\u00e4hlen", Art.OBEN),
    SECHS("6er", "nur Sechser z\u00e4hlen", Art.OBEN),
    GESAMT("gesamt", "Summe der oberen Eintr\u00e4ge"),
    BONUS("Bonus ab 63", "ab 63 Punkten oben zus\u00e4tzlich 35 Bonuspunkte"),
    OSUMME("obere Summe", "Summe der oberen Eintr\u00e4ge plus Bonuspunkte"),
    DREIERPASCH("Dreierpasch", "alle Augen z\u00e4hlen", Art.UNTEN),
    VIERERPASCH("Viererpasch", "alle Augen z\u00e4hlen", Art.UNTEN),
    FULLHOUSE("Full-House", "25 Punkte", Art.UNTEN),
    KLEINESTRASSE("Kleine Stra\u00dfe", "30 Punkte", Art.UNTEN),
    GROSSESTRASSE("Gro\u00dfe Stra\u00dfe", "40 Punkte", Art.UNTEN),
    JAFUFFY("JaFuffy", "50 Punkte", Art.UNTEN),
    CHANCE("Chance", "alle Augen z\u00e4hlen", Art.UNTEN),
    USUMME("untere Summe", "Summe der unteren Eintr\u00e4ge"),
    ESUMME("Endsumme", "obere und untere Summe zusammen");

    static final Tabzeile[] ALLE;
    static final int ANZAHL;
    public static final Tabzeile[] OBEN;
    public static final Tabzeile[] UNTEN;
    private final String bezeichnung;
    private final String beschreibung;
    private final Art art;

    static {
        ALLE = new Tabzeile[]{EINS, ZWEI, DREI, VIER, FUENF, SECHS, DREIERPASCH, VIERERPASCH, FULLHOUSE, KLEINESTRASSE, GROSSESTRASSE, JAFUFFY, CHANCE};
        ANZAHL = Tabzeile.values().length;
        OBEN = new Tabzeile[]{EINS, ZWEI, DREI, VIER, FUENF, SECHS};
        UNTEN = new Tabzeile[]{DREIERPASCH, VIERERPASCH, FULLHOUSE, KLEINESTRASSE, GROSSESTRASSE, JAFUFFY, CHANCE};
    }

    public static Tabzeile eintrag(int nummer) {
        return Tabzeile.values()[nummer];
    }

    public static Tabzeile oben(int augen) {
        return Tabzeile.eintrag(augen - 1);
    }

    private Tabzeile(String bezeichnung, String beschreibung) {
        this(bezeichnung, beschreibung, Art.DERIVAT);
    }

    private Tabzeile(String bezeichnung, String beschreibung, Art art) {
        this.bezeichnung = bezeichnung;
        this.beschreibung = beschreibung;
        this.art = art;
    }

    boolean oben() {
        return this.art == Art.OBEN;
    }

    public boolean alle() {
        return this.oben() || this.unten();
    }

    public boolean unten() {
        return this.art == Art.UNTEN;
    }

    public String beschreibung() {
        return this.beschreibung;
    }

    public String bezeichnung() {
        return this.bezeichnung;
    }

    private static enum Art {
        DERIVAT,
        OBEN,
        UNTEN;

    }
}

