/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;

public class Range
implements Serializable {
    private double min;
    private double max;

    public Range(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Requires min <= max.");
        }
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getLength() {
        return this.max - this.min;
    }

    public boolean contains(double value) {
        return value >= this.min && value <= this.max;
    }

    public double peggedValue(double value) {
        return Math.max(this.min, Math.min(this.max, value));
    }

    public boolean intersects(double bound1, double bound2) {
        double lowerBound = Math.min(bound1, bound2);
        double upperBound = Math.max(bound1, bound2);
        if (upperBound < this.min) {
            return false;
        }
        return !(lowerBound > this.max);
    }

    public boolean intersects(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        return this.intersects(range.getMin(), range.getMax());
    }

    public double percent(double value) {
        return (value - this.min) / this.getLength();
    }

    public double percent(double value, boolean inverted) {
        double p = this.percent(value);
        if (inverted) {
            p = 1.0 - p;
        }
        return p;
    }

    public double value(double percent) {
        return this.min + percent * (this.max - this.min);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range that = (Range)obj;
        if (this.min != that.min) {
            return false;
        }
        return this.max == that.max;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash = 43 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return hash;
    }

    public String toString() {
        return "Range[" + this.min + ", " + this.max + "]";
    }
}

