/******************************************************************************
 ** $Id: Absprache.java 814 2015-11-13 13:02:30Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.net.URL;

import javax.sound.sampled.AudioSystem;

/** Bereitstellung von URLs fr Ressourcen. */
public enum Ressource {

    /** Liefert eine Ressource zurck, welche sich auf einen Text aus der Anleitung bezieht. */
    ANLEITUNG("/Anleitung/"),
    /** Liefert eine Web-Ressource zurck, welche sich auf einen Text aus der Anleitung bezieht. */
    ANLEITUNG_WEB("http://jafuffy.3kelvin.de/anleitung/"),
    /** Liefert eine Ressource zurck, welche sich auf einen Informationstext bezieht. */
    LIESMICH("/Liesmich/"),
    /** Liefert eine Web-Ressource zurck, welche sich auf einen Informationstext bezieht. */
    LIESMICH_WEB("http://jafuffy.3kelvin.de/liesmich/"),
    /** Liefert eine Ressource zurck, welche sich auf einen Sound bezieht. */
    SOUND("sounds/"),
    /** Liefert eine Ressource zurck, welche sich auf eine Grafik oder ein Icon bezieht. */
    ICON("icons/");

    /** Stummschaltung. */
    public static void schalteStumm() {
        stumm = true;
    }

    /** @return Gibt an, ob Soundsystem vorhanden ist. */
    public static boolean soundsystem() {
        return !stumm && AudioSystem.getMixerInfo().length > 0;
    }

    /** Gibt an, ob Stummschaltung vorliegt. */
    private static boolean stumm = false;

    /** Art der Ressource. */
    private final String art;

    /**
     * Konstruktor.
     *
     * @param art
     *            Die Art der Ressource.
     */
    Ressource(String art) {
        this.art = art;
    }

    /**
     * Baut eine URL fr eine Ressource zusammen.
     *
     * @param name
     *            Name der Ressource
     * @return Liefert URL fr gefundene Ressource zurck
     */
    public URL url(String name) {
        URL url;
        url = Ressource.class.getResource(art + name);
        if (url == null) {
            System.out.println("Ressource \"" + art + name + "\" nicht gefunden!");
        }
        return url;
    }

    /**
     * Baut eine URL zusammen, mit einer alternativen Rckfallmglichkeit.
     * 
     * @param name
     *            Name der Ressource
     * @param alternative
     *            Alternative Ressource, aus der die URL gebaut wird.
     * 
     */
    public URL url(String name, Ressource alternative) {
        URL seite = url(name);
        if (seite == null) {
//            try {
//                seite = new URL(alternative.art + name);
//            } catch (MalformedURLException exception) {
//                System.out.println("Ressource \"" + alternative.art + name + "\" nicht gefunden!");
//                exception.printStackTrace();
//            }
        }
        return seite;
    }

}
