/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.event;

import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.UninstallerListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.core.handler.ProgressHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UninstallerListeners {
    private final List<UninstallerListener> listeners = new ArrayList<UninstallerListener>();
    private final Prompt prompt;
    private boolean fileListener;

    public UninstallerListeners(Prompt prompt) {
        this.prompt = prompt;
    }

    public void add(UninstallerListener listener) {
        this.listeners.add(listener);
        if (!this.fileListener && listener.isFileListener()) {
            this.fileListener = true;
        }
    }

    public void initialise() {
        for (UninstallerListener listener : this.listeners) {
            listener.initialise();
        }
    }

    public void beforeDeletion(List<File> files, ProgressListener listener) {
        ProgressHandler handler = new ProgressHandler(listener, this.prompt);
        for (UninstallerListener l : this.listeners) {
            try {
                l.beforeDelete(files);
            }
            catch (IzPackException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IzPackException(exception);
            }
        }
    }

    public void beforeDelete(File file, ProgressListener listener) {
        ProgressHandler handler = new ProgressHandler(listener, this.prompt);
        if (this.fileListener) {
            for (UninstallerListener l : this.listeners) {
                if (!l.isFileListener()) continue;
                l.beforeDelete(file);
            }
        }
    }

    public void afterDelete(File file, ProgressListener listener) {
        ProgressHandler handler = new ProgressHandler(listener, this.prompt);
        if (this.fileListener) {
            for (UninstallerListener l : this.listeners) {
                if (!l.isFileListener()) continue;
                l.afterDelete(file);
            }
        }
    }

    public void afterDeletion(List<File> files, ProgressListener listener) {
        ProgressHandler handler = new ProgressHandler(listener, this.prompt);
        for (UninstallerListener l : this.listeners) {
            try {
                l.afterDelete(files, listener);
            }
            catch (IzPackException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new IzPackException(exception);
            }
        }
    }
}

