/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Geraeusch;
import jafuffy.bedienung.Tabelle;
import jafuffy.logik.Analyse;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Turnier;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public abstract class Auswahl
extends DefaultCellEditor
implements ActionListener {
    private static final int ABSTAND = 4;
    private static final NumberFormat NF;
    protected static final Geraeusch HURRA;
    private final JButton setzen;
    protected int clicks;
    protected Tabzeile aktuell;
    protected Tabelle tabelle;
    protected final Turnier turnier;

    static {
        HURRA = new Geraeusch("Hurra.wav");
        NF = NumberFormat.getInstance(Locale.GERMAN);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(2);
    }

    public Auswahl(Turnier turnier) {
        super(new JCheckBox());
        this.turnier = turnier;
        this.setClickCountToStart(1);
        this.setzen = new JButton("setzen");
        this.setzen.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setzen.setFocusPainted(false);
        this.setzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ++Auswahl.this.clicks;
                if (Auswahl.this.clicks == 2 || Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
                    Auswahl.this.fireEditingStopped();
                    Auswahl.this.reagiereAufSetzen();
                }
            }
        });
        this.editorComponent = this.setzen;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.aktiviere(this.turnier.auswertung().analyse().bester());
        this.doClick();
    }

    public void doClick() {
        this.setzen.doClick();
        if (!Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
            this.setzen.doClick();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.aktiviere(Tabzeile.eintrag(row));
        this.tabelle = (Tabelle)table;
        this.aktualisiere();
        return this.editorComponent;
    }

    public abstract void reagiereAufWurf();

    protected void aktualisiere() {
        if (this.aktuell != null) {
            this.fireEditingCanceled();
            Auswertung auswertung = this.turnier.auswertung();
            Analyse analyse = auswertung.analyse();
            String text = "<p>Jetzt klicken liefert " + analyse.wert(this.aktuell) + " Punkte." + "</p>";
            if (auswertung.sindTippsAngefordert()) {
                text = String.valueOf(text) + "<p>Bewertung: " + NF.format(analyse.wichtung(this.aktuell)) + "</p>";
            }
            text = String.valueOf(text) + "<p><small>\u00dcberspringen der Best\u00e4tigung im Men\u00fc: Einstellungen&rarr;Setzen durch Einfachklick</small></p>";
            this.editorComponent.setToolTipText("<html>" + text + "<html>");
        }
    }

    protected abstract void reagiereAufSetzen();

    void aktiviere(Tabzeile eintrag) {
        this.aktuell = eintrag;
        this.clicks = 0;
    }
}

