/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.bedienung.Auswahl;
import jafuffy.logik.Aenderungen;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Beginner;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.Punkte;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Variante;
import jafuffy.logik.Wuerfel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Random;

public class Turnier
extends Aenderungen<CEAblauf>
implements ActionListener,
Serializable {
    private static final long serialVersionUID = -8157448193770055452L;
    private static final int EINTRAEGE = 13;
    public static final int WUERFEL = 5;
    public static final int RUNDEN = 3;
    private final Wuerfel[] wuerfel;
    private final Variante variante;
    private final ArrayList<Spieler> teilnehmer;
    private final Auswertung auswertung;
    private final int maximalanzahl;
    private final Beginner beginnmodus;
    private final Spieler kopieAktiver = new Spieler("", 0);
    private Spieler aktiver;
    private int spielindex = 0;
    private int eintragsanzahl = 0;
    private int spielerindex = 0;
    private int startindex;
    private HashMap<Spieler, ArrayList<Integer>> verlaeufe;
    private HashMap<Spieler, Integer> turnierstaende;
    private transient Statistik statistik;
    private transient Punkte punkte;
    private transient Spieler merkerAktiver;
    private transient int merkerSpielanzahl;
    private transient int merkerEintragsanzahl;
    private transient int merkerSpielerindex;

    public Turnier(Variante variante, ArrayList<Spieler> spieler, int startindex, Beginner beginnmodus, int anzahl) {
        this.variante = variante;
        this.teilnehmer = spieler;
        this.startindex = startindex;
        this.beginnmodus = beginnmodus;
        this.maximalanzahl = anzahl;
        this.wuerfel = new Wuerfel[5];
        int i = 0;
        while (i < 5) {
            this.wuerfel[i] = new Wuerfel(i + 1);
            ++i;
        }
        this.auswertung = variante.auswertung(this.wuerfel);
        for (Spieler s : spieler) {
            s.initialisiere();
        }
        this.aktiviere(startindex);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        if (ac.equals("Gewuerfelt")) {
            this.wuerfle();
        } else if (ac.equals("Rueckgaengig")) {
            this.annulliere();
        } else if (ac.equals("Vorschlagen")) {
            this.auswertung.erstelleVorschlag();
        } else if (ac.equals("Beenden")) {
            this.beende();
        }
    }

    public Spieler aktiver() {
        return this.aktiver;
    }

    public Auswahl auswahl() {
        return this.variante.auswahl(this);
    }

    public Auswertung auswertung() {
        return this.auswertung;
    }

    public void beende() {
        if (this.aktiver != null) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(this.spielindex == this.maximalanzahl && this.maximalanzahl > 0 ? CEAblauf.ENDE : CEAblauf.ABBRUCH);
            this.aktiver.warte();
            this.aktiver = null;
        }
    }

    public boolean beendet() {
        return this.aktiver == null;
    }

    public String beschreibung() {
        String s = new String("Mitspieler: ");
        ListIterator<Spieler> iterator = this.teilnehmer.listIterator();
        while (iterator.hasNext()) {
            s = String.valueOf(s) + iterator.next().toString();
            s = iterator.hasNext() ? String.valueOf(s) + ", " : String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + "\n" + this.auswertung.toString() + ". " + (this.teilnehmer.size() > 1 ? (Object)((Object)this.beginnmodus) + ". " : "");
        s = String.valueOf(s) + (this.maximalanzahl == 0 ? "Beliebig viele Spiele." : "Im " + (this.spielindex + 1) + ". von " + this.maximalanzahl + (this.maximalanzahl != 1 ? " Spielen" : " Spiel") + ".");
        return s;
    }

    public int maximalanzahl() {
        return this.maximalanzahl;
    }

    public void pausiere() {
        this.fireStateChanged(CEAblauf.PAUSE);
    }

    public Punkte punkte() {
        return this.punkte;
    }

    public void setze(Tabzeile eintrag) {
        this.setze(eintrag, this.auswertung.analyse().wert(eintrag));
    }

    public void setze(Tabzeile eintrag, int wert) {
        this.merke();
        this.aktiver.setze(eintrag, wert, true);
        this.beendeSetzen();
    }

    public void setzeFort(Statistik statistik) {
        this.statistik = statistik;
        this.auswertung.reagiereAufWurf(this.aktiver);
        this.punkte = new Punkte(this.teilnehmer, this.auswertung);
        if (this.verlaeufe == null) {
            this.verlaeufe = new HashMap(this.teilnehmer.size());
            this.turnierstaende = new HashMap(this.teilnehmer.size());
            for (Spieler spieler : this.teilnehmer) {
                this.verlaeufe.put(spieler, new ArrayList());
                this.verlaeufe.get(spieler).add(0);
                this.turnierstaende.put(spieler, 0);
            }
        }
        statistik.verfolge(this.variante, this.maximalanzahl, this.teilnehmer, this.auswertung.mittelwert(), this.auswertung.abweichung(), this.verlaeufe, this.turnierstaende);
    }

    public ArrayList<Spieler> spieler() {
        return this.teilnehmer;
    }

    public int spielnummer() {
        return this.spielindex + 1;
    }

    public void starte() {
        this.fireStateChanged(CEAblauf.START);
    }

    public Wuerfel[] wuerfel() {
        return this.wuerfel;
    }

    public Wuerfel wuerfel(int i) {
        return this.wuerfel[i];
    }

    private void annulliere() {
        if (this.eintragsanzahl != this.merkerEintragsanzahl) {
            this.statistik.annulliere();
        }
        this.aktiver.warte();
        this.spielerindex = this.merkerSpielerindex;
        this.eintragsanzahl = this.merkerEintragsanzahl;
        this.spielindex = this.merkerSpielanzahl;
        this.aktiver = this.merkerAktiver;
        this.kopieAktiver.sichere(this.aktiver);
        this.aktiver.aktualisiere();
        this.auswertung.reagiereAufWurf(this.aktiver);
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            w.darstellungsmodell().setSelected(false);
            ++n2;
        }
        this.auswertung.aktiviereTipps(false);
        this.fireStateChanged(CEAblauf.RUECKGAENGIG);
    }

    private void beendeRunde() {
        ++this.eintragsanzahl;
        this.spielerindex = 0;
        this.statistik.beendeRunde();
    }

    private void beendeSetzen() {
        this.aktiviere((this.teilnehmer.indexOf(this.aktiver) + 1) % this.teilnehmer.size());
        ++this.spielerindex;
        if (this.spielerindex >= this.teilnehmer.size()) {
            this.beendeRunde();
            if (this.eintragsanzahl >= 13) {
                this.aktiver.warte();
                this.auswertung.aktiviereTipps(false);
                this.fireStateChanged(CEAblauf.RESULTAT);
                this.beendeSpiel();
            }
        }
        if (this.maximalanzahl > 0 && this.spielindex == this.maximalanzahl) {
            this.beende();
        } else if (this.spielindex == this.merkerSpielanzahl) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(CEAblauf.GESETZT);
        } else {
            this.fireStateChanged(CEAblauf.SPIEL);
        }
    }

    private void beendeSpiel() {
        Spieler verlierer;
        Spieler gewinner = verlierer = this.teilnehmer.get(0);
        for (Spieler spieler : this.teilnehmer) {
            if (spieler.endsumme() < verlierer.endsumme()) {
                verlierer = spieler;
            }
            if (spieler.endsumme() <= gewinner.endsumme()) continue;
            gewinner = spieler;
        }
        switch (this.beginnmodus) {
            case VERLIERER: {
                this.startindex = this.teilnehmer.indexOf(verlierer);
                break;
            }
            case GEWINNER: {
                this.startindex = this.teilnehmer.indexOf(gewinner);
                break;
            }
            case REIHUM: {
                ++this.startindex;
                this.startindex %= this.teilnehmer.size();
                break;
            }
            case ZUFALL: {
                this.startindex = new Random().nextInt(this.teilnehmer.size());
                break;
            }
        }
        this.statistik.beendeSpiel();
        for (Spieler spieler : this.teilnehmer) {
            spieler.initialisiere();
        }
        this.aktiviere(this.startindex);
        ++this.spielindex;
        this.eintragsanzahl = 0;
    }

    private void merke() {
        this.merkerSpielerindex = this.spielerindex;
        this.merkerEintragsanzahl = this.eintragsanzahl;
        this.merkerSpielanzahl = this.spielindex;
        this.merkerAktiver = this.aktiver;
        this.aktiver.sichere(this.kopieAktiver);
    }

    private void wuerfle() {
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            if (w.darstellungsmodell().isSelected()) {
                w.wirf();
            }
            ++n2;
        }
        this.fireStateChanged(CEAblauf.WUERFELN);
        this.aktiver.reagiere();
        this.auswertung.reagiereAufWurf(this.aktiver);
        this.auswertung.aktiviereTipps(false);
        this.fireStateChanged(CEAblauf.GEWUERFELT);
    }

    void aktiviere(int index) {
        this.aktiver = this.teilnehmer.get(index);
        this.aktiver.aktiviere();
    }

    Spieler spieler(int i) {
        return this.teilnehmer.get(i);
    }
}

