/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.bedienung.Auswahl;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.auswertung.Erweitert;
import jafuffy.logik.auswertung.ImHieb;
import jafuffy.logik.auswertung.Klassisch;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public enum Variante {
    KLASSISCH("Klassische Regeln", Klassisch.class, Klassisch.AUSWAHLKLASSE),
    IMHIEB("Im-Hieb-Regeln", ImHieb.class, ImHieb.AUSWAHLKLASSE),
    ERWEITERT("Erweiterte Regeln", Erweitert.class, Erweitert.AUSWAHLKLASSE);

    public static final int ANZAHL;
    private final String spielregelname;
    private final Constructor<? extends Auswertung> auswertungskonstruktor;
    private final Constructor<? extends Auswahl> auswahlkonstruktor;

    static {
        ANZAHL = Variante.values().length;
    }

    private Variante(String spielregelname, Class<? extends Auswertung> auswertungsklasse, Class<? extends Auswahl> auswahlklasse) {
        this.spielregelname = spielregelname;
        this.auswertungskonstruktor = this.auswertungskonstruktor(auswertungsklasse);
        this.auswahlkonstruktor = this.auswahlkonstruktor(auswahlklasse);
    }

    public Auswahl auswahl(Turnier turnier) {
        try {
            return this.auswahlkonstruktor.newInstance(turnier);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Auswertung auswertung(Wuerfel[] wuerfel) {
        try {
            return this.auswertungskonstruktor.newInstance(new Object[]{wuerfel});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.spielregelname;
    }

    private Constructor<? extends Auswahl> auswahlkonstruktor(Class<? extends Auswahl> klasse) {
        try {
            return klasse.getConstructor(Turnier.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Constructor<? extends Auswertung> auswertungskonstruktor(Class<? extends Auswertung> klasse) {
        try {
            return klasse.getConstructor(Wuerfel[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

