/******************************************************************************
 ** $Id: ImHieb.java 1017 2016-05-28 20:35:09Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung.auswahl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import jafuffy.logik.Turnier;

/** Auswahl der Zelle, in die das Wrfelresultat gesetzt wird (Im-Hieb-Variante). Gibt Im-Hieb-Meldung aus. */
@SuppressWarnings("serial")
public class ImHieb extends Klassisch {

    /** Verzgerung in Millisekunden nach dem Abspielen des Hurra-Tons bei Im-Hieb bis der Wurf gesetzt wird. */
    private static final int DELAY = 800;

    /** Die Auswertung zu dieser Auswahl. */
    private final jafuffy.logik.auswertung.ImHieb auswertung;
    /** Die Analyse zu dieser Auswahl. */
    private final jafuffy.logik.analyse.ImHieb analyse;
    /** Verzgertes Setzen zum Absetzen einer Nachricht. */
    private final Timer timer = new Timer(DELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            auswertung.deaktiviereImHiebNachricht();
            turnier.setze(aktuell);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };

    /**
     * Konstruktor.
     *
     * @param turnier
     *            Das Turnier, fr welches die Auswahl getroffen werden soll.
     */
    public ImHieb(Turnier turnier) {
        super(turnier);
        auswertung = (jafuffy.logik.auswertung.ImHieb) turnier.auswertung();
        analyse = (jafuffy.logik.analyse.ImHieb) auswertung.analyse();
    }

    @Override
    protected void reagiereAufSetzen() {
        if (analyse.istImHieb(turnier.aktiver(), aktuell)) {
            auswertung.aktiviereImHiebNachricht(aktuell);
            HURRA.play();
            turnier.pausiere();
            timer.start();
        } else {
            turnier.setze(aktuell);
        }
    }

}
