/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.logik.Bestenlistenmodell;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEStatistik;
import jafuffy.logik.Statistik;
import jafuffy.logik.Variante;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class Bestenliste
extends JDialog
implements PropertyChangeListener,
ChangeListener {
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final ImageIcon MEDAILLE = Grafik.icon("Goldwuerfel.png");
    private static final int ZWISCHENRAUM = 8;
    private final JLabel[] anzahl = new JLabel[Variante.ANZAHL];
    private final HashMap<Variante, Bestenlistenmodell> bestenlistenmodelle;
    private final JLabel[] durchschnitt = new JLabel[Variante.ANZAHL];
    private final JTabbedPane kartei = new JTabbedPane();
    private final JLabel[] standardabweichung = new JLabel[Variante.ANZAHL];
    private final Statistik statistik;

    public Bestenliste(Statistik statistik, int variantenindex) {
        this.statistik = statistik;
        UIManager.addPropertyChangeListener(this);
        this.bestenlistenmodelle = statistik.bestenlistenmodelle();
        this.erstelleKarteikarten(variantenindex);
        this.zeigeStatistikkenndaten();
        this.setContentPane(this.hauptfeld(this.ok()));
        this.setTitle("JaFuffy (Liste der zehn besten Punktzahlen)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEStatistik)((Object)cej.ereignis())) {
                case TURNIER_START: 
                case TURNIER_WEITER: {
                    this.kartei.setSelectedIndex(this.statistik.variante().ordinal());
                    break;
                }
                case SPIEL_ENDE: {
                    this.bestenlistenmodelle.get((Object)this.statistik.variante()).aktualisieren();
                    this.kartei.setSelectedIndex(this.statistik.variante().ordinal());
                    this.zeigeStatistikkenndaten();
                    break;
                }
            }
        }
    }

    private void erstelleKarteikarten(int variantenindex) {
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante variante = varianteArray[n2];
            int i = variante.ordinal();
            JPanel statistikfelder = new JPanel(new FlowLayout());
            this.anzahl[i] = new JLabel();
            this.anzahl[i].setToolTipText("Anzahl aller bisherigen Spiele (" + variante.toString() + ")");
            statistikfelder.add(this.anzahl[i]);
            this.durchschnitt[i] = new JLabel();
            this.durchschnitt[i].setToolTipText("Punktedurchschnitt aller bisherigen Spiele (" + variante.toString() + ")");
            statistikfelder.add(this.durchschnitt[i]);
            this.standardabweichung[i] = new JLabel();
            this.standardabweichung[i].setToolTipText("Standardabweichung f\u00fcr bisherige Spiele (" + variante.toString() + ")");
            statistikfelder.add(this.standardabweichung[i]);
            JPanel daten = new JPanel(new BorderLayout());
            daten.add((Component)statistikfelder, "North");
            daten.add((Component)this.scrollfeld(this.tabelle(this.bestenlistenmodelle.get((Object)variante))), "Center");
            this.kartei.addTab(variante.toString(), daten);
            ++n2;
        }
        this.kartei.setSelectedIndex(variantenindex);
    }

    private JPanel hauptfeld(JButton ok) {
        JPanel hauptfeld = new JPanel(new BorderLayout(0, 4));
        hauptfeld.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        hauptfeld.add((Component)this.kartei, "Center");
        hauptfeld.add((Component)ok, "South");
        return hauptfeld;
    }

    private JButton ok() {
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Bestenliste.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(ok);
        return ok;
    }

    private JScrollPane scrollfeld(JTable tabelle) {
        JScrollPane scrollfeld = new JScrollPane(tabelle);
        scrollfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()), BorderFactory.createCompoundBorder(new MatteBorder(MEDAILLE), new EtchedBorder(1))));
        scrollfeld.setPreferredSize(new Dimension(8 + 16 * MEDAILLE.getIconWidth(), 8 + 8 * MEDAILLE.getIconWidth()));
        return scrollfeld;
    }

    private int spaltenbreite(String titel) {
        FontMetrics metrik = this.getFontMetrics(this.getFont());
        int breite = metrik.stringWidth(titel);
        return breite;
    }

    private JTable tabelle(Bestenlistenmodell modell) {
        JTable tabelle = new JTable(modell){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int zeile, int spalte) {
                DefaultTableCellRenderer zelle = (DefaultTableCellRenderer)super.prepareRenderer(renderer, zeile, spalte);
                zelle.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
                return zelle;
            }
        };
        tabelle.getColumnModel().getColumn(Spalten.RANG.ordinal()).setPreferredWidth(this.spaltenbreite("Rang"));
        tabelle.getColumnModel().getColumn(Spalten.NAME.ordinal()).setPreferredWidth(this.spaltenbreite("!Mitspieler!"));
        tabelle.getColumnModel().getColumn(Spalten.PUNKTE.ordinal()).setPreferredWidth(this.spaltenbreite("Punkte"));
        tabelle.getColumnModel().getColumn(Spalten.DATUM.ordinal()).setPreferredWidth(this.spaltenbreite("00.00.0000"));
        tabelle.getColumnModel().getColumn(Spalten.KOMMENTAR.ordinal()).setMinWidth(this.spaltenbreite("Ein Spielerkommentar."));
        tabelle.setRowSelectionAllowed(false);
        return tabelle;
    }

    private void zeigeStatistikkenndaten() {
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante variante = varianteArray[n2];
            int i = variante.ordinal();
            this.anzahl[i].setText("Anzahl: " + this.statistik.n(variante));
            if (this.statistik.n(variante) > 1) {
                this.durchschnitt[i].setText("Durchschnitt: " + NumberFormat.getInstance().format(Math.floor(this.statistik.durchschnitt(variante) * 10.0 + 0.5) / 10.0));
                this.standardabweichung[i].setText("Standardabweichung: " + NumberFormat.getInstance().format(Math.floor(this.statistik.standardabweichung(variante) * 10.0 + 0.5) / 10.0));
            } else {
                this.durchschnitt[i].setText("Durchschnitt: -");
                this.standardabweichung[i].setText("Standardabweichung: -");
            }
            ++n2;
        }
    }

    private static enum Spalten {
        RANG,
        NAME,
        PUNKTE,
        DATUM,
        KOMMENTAR;

    }
}

