/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Signal;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Manager;
import jafuffy.logik.Turnier;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Fortsetzung
extends JDialog
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    private static final int SCHACHTSPALTEN = 32;
    private static final int SCHACHTZEILEN = 2;
    private static final int ABSTAND_OK = 32;
    private static final int AUTOMATIK = 0;
    private static final String DATEINAMENSBASIS = "Turnier";
    private static final String DATEINAMENSENDUNG = "obj";
    private static final int DELAY = 2500;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final String FORTSETZUNG = "Fortsetzung";
    private static final String LEER = "Leer";
    private static final String[] SCHACHTNAMEN = new String[]{"Automatische Sicherung", "Manuelle Sicherung A", "Manuelle Sicherung B", "Manuelle Sicherung C", "Manuelle Sicherung D"};
    private static final int SICHERUNGEN = 4;
    private static final int BUTTONABSTAND = 8;
    private String alterText;
    private String altesDatum;
    private final JDialog bestaetigung = new JDialog(this);
    private final JPanel dialog = new JPanel(new CardLayout());
    private final Eigenschaften eigenschaften;
    private final JButton fortsetzen = new JButton("Turnier abspeichern");
    private int gewaehlt = -1;
    private int gewaehltVorAbbruch;
    private final ButtonGroup gruppe = new ButtonGroup();
    private Manager manager;
    private final JButton ok = new JButton("Keine Sicherungen vorhanden!");
    private final JRadioButton[] sicherungsbuttons = new JRadioButton[5];
    private final JTextArea[] textfelder = new JTextArea[5];
    private boolean speichern;
    private Turnier turnier;

    private static String beschreibung(File stand) {
        String beschreibung = "\n";
        if (stand.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(stand));
                beschreibung = (String)ois.readObject();
                ois.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return beschreibung;
    }

    private static String datum(File stand) {
        return stand.exists() ? DateFormat.getDateTimeInstance(2, 3, Locale.GERMANY).format(new Date(stand.lastModified())) : "---";
    }

    private static boolean frage(Component umgebung, File datei) {
        int wahl = JOptionPane.showConfirmDialog(umgebung, "Automatisch gesicherten Turnierstand (" + Fortsetzung.datum(datei) + ") gefunden:\n" + Fortsetzung.beschreibung(datei) + "\n" + "Soll dieses Turnier fortgesetzt werden?", "JaFuffy (Men\u00fc \"Einstellungen - Meldungen - Erinnerung...\")", 0);
        return wahl == 0;
    }

    public Fortsetzung(Eigenschaften eigenschaften, Fenster fenster) {
        super(fenster);
        this.eigenschaften = eigenschaften;
        UIManager.addPropertyChangeListener(this);
        this.dialog.add((Component)this.baueLeerfeld(), LEER);
        this.dialog.add((Component)this.baueFortsetzungsfeld(), FORTSETZUNG);
        JScrollPane pane = new JScrollPane(this.dialog);
        pane.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.setContentPane(pane);
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String ac = event.getActionCommand();
        if (ac.equals("Speichern")) {
            this.sichere(this.gewaehlt, this.turnier, this.textfelder[this.gewaehlt].getText());
            this.firePropertyChange("Speichern", false, true);
        } else if (ac.equals("Fortsetzen")) {
            this.setVisible(false);
            this.manager.betreibe(this.lade(this.gewaehlt));
            this.firePropertyChange("Speichern", this.gewaehlt == 0, this.gewaehlt != 0);
        } else if (ac.equals("OK")) {
            this.setVisible(false);
        } else if (ac.length() == 1) {
            int neu;
            int alt = this.gewaehlt;
            this.gewaehlt = neu = Integer.parseInt(ac);
            if (this.speichern) {
                this.fortsetzen.setEnabled(true);
                this.sicherungsbuttons[alt].setText(this.altesDatum);
                this.textfelder[alt].setEditable(false);
                this.textfelder[alt].setEnabled(false);
                this.textfelder[alt].setText(this.alterText);
                this.altesDatum = this.sicherungsbuttons[neu].getText();
                this.sicherungsbuttons[neu].setText(String.valueOf(SCHACHTNAMEN[neu]) + " von jetzt");
                this.textfelder[neu].setEditable(true);
                this.textfelder[neu].setEnabled(true);
                this.alterText = this.textfelder[neu].getText();
                this.textfelder[neu].setText(this.turnier.beschreibung());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            Turnier quelle = (Turnier)cej.quelle(Turnier.class);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.turnier = quelle;
                    break;
                }
                case ABBRUCH: {
                    this.sichere(0, quelle, null);
                    this.textfelder[0].setText(quelle.beschreibung());
                    break;
                }
                case ENDE: {
                    this.datei(0).delete();
                    this.textfelder[0].setText(null);
                    this.turnier = null;
                    break;
                }
            }
        }
    }

    public void verbinde(Manager manager) {
        this.manager = manager;
    }

    public void versuche() {
        boolean kalt = this.eigenschaften.kaltstart();
        boolean warm = this.eigenschaften.warmstart();
        boolean erinnerung = this.eigenschaften.aktiv("Erinnerung");
        if ((kalt || warm || erinnerung) && this.datei(0).exists()) {
            if (erinnerung) {
                Signal.WARNUNG.play();
                if (Fortsetzung.frage(this.getOwner(), this.datei(0))) {
                    this.lade();
                }
            } else if (warm) {
                this.lade();
            }
            this.eigenschaften.quittiereNeustartAnforderung();
        }
    }

    private JPanel baueFortsetzungsfeld() {
        JPanel staendefeld = this.baueStaendefeld();
        staendefeld.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel leiste = this.baueLeiste();
        leiste.setBorder(new EmptyBorder(4, 0, 2, 0));
        JPanel fortsetzung = new JPanel(new BorderLayout());
        fortsetzung.setBorder(new EmptyBorder(0, 4, 0, 4));
        fortsetzung.add((Component)staendefeld, "Center");
        fortsetzung.add((Component)leiste, "South");
        return fortsetzung;
    }

    private JPanel baueLeerfeld() {
        this.baueOk();
        JPanel leer = new JPanel();
        leer.setLayout(new BoxLayout(leer, 1));
        leer.add(Box.createVerticalGlue());
        leer.add((Component)this.ok, "Center");
        leer.add(Box.createVerticalGlue());
        return leer;
    }

    private JPanel baueLeiste() {
        this.fortsetzen.addActionListener(this);
        this.fortsetzen.setActionCommand("Fortsetzen");
        JButton abbruch = new JButton("Abbruch");
        abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Fortsetzung.this.speichern) {
                    Fortsetzung.this.textfelder[Fortsetzung.this.gewaehlt].setText(Fortsetzung.this.alterText);
                }
                Fortsetzung.this.gewaehlt = Fortsetzung.this.gewaehltVorAbbruch;
                Fortsetzung.this.setVisible(false);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(this.fortsetzen);
        leiste.add(abbruch);
        return leiste;
    }

    private void baueOk() {
        this.ok.addActionListener(this);
        this.ok.setActionCommand("OK");
        this.ok.setAlignmentX(0.5f);
        this.ok.setMargin(new Insets(32, 32, 32, 32));
    }

    private JPanel baueStaendefeld() {
        int i = 0;
        while (i <= 4) {
            this.textfelder[i] = new JTextArea("\n", 2, 32);
            this.textfelder[i].setFont(new Font("Dialog", 0, this.textfelder[i].getFont().getSize()));
            this.textfelder[i].setText(Fortsetzung.beschreibung(this.datei(i)));
            ++i;
        }
        JPanel staendefeld = new JPanel();
        staendefeld.setLayout(new BoxLayout(staendefeld, 1));
        int i2 = 0;
        while (i2 <= 4) {
            this.sicherungsbuttons[i2] = new JRadioButton();
            this.sicherungsbuttons[i2].addActionListener(this);
            this.sicherungsbuttons[i2].setActionCommand(String.valueOf(i2));
            this.gruppe.add(this.sicherungsbuttons[i2]);
            this.textfelder[i2].setToolTipText("<html><p>Beschreibt gespeicherten Turnierstand.</p><p>Kann vor dem Speichern ge\u00e4ndert werden.</p></html>");
            this.textfelder[i2].setBorder(BorderFactory.createEtchedBorder());
            this.textfelder[i2].setDisabledTextColor(Color.DARK_GRAY);
            JPanel schachtfeld = new JPanel(new BorderLayout());
            schachtfeld.add((Component)this.sicherungsbuttons[i2], "North");
            schachtfeld.add((Component)this.textfelder[i2], "Center");
            staendefeld.add(Box.createVerticalStrut(2));
            staendefeld.add(schachtfeld);
            staendefeld.add(Box.createVerticalStrut(4));
            ++i2;
        }
        this.textfelder[0].setToolTipText("<html><p>Beschreibt automatisch gespeicherten Turnierstand.</p><p>Der Text wird automatisch erzeugt.</p></html>");
        return staendefeld;
    }

    private void belegeAuswahlMitDaten(String text, String cmd) {
        Vector<Integer> auswahlgruppe = new Vector<Integer>(5);
        this.sicherungsbuttons[0].setSelected(false);
        this.sicherungsbuttons[0].setText(String.valueOf(SCHACHTNAMEN[0]) + " (" + Fortsetzung.datum(this.datei(0)) + ")");
        this.sicherungsbuttons[0].setToolTipText("Schacht entspricht gespeichertem Turnierstand");
        this.textfelder[0].setEditable(false);
        this.textfelder[0].setEnabled(false);
        if (!this.speichern && this.datei(0).exists()) {
            this.sicherungsbuttons[0].setEnabled(true);
            auswahlgruppe.add(0);
        } else {
            this.sicherungsbuttons[0].setEnabled(false);
        }
        int i = 1;
        while (i <= 4) {
            File stand = this.datei(i);
            this.sicherungsbuttons[i].setText(String.valueOf(SCHACHTNAMEN[i]) + " (" + Fortsetzung.datum(stand) + ")");
            this.sicherungsbuttons[i].setToolTipText(this.speichern ? "W\u00e4hle Schacht aus, in den gespeichert wird" : "Schacht entspricht gespeichertem Turnierstand");
            this.sicherungsbuttons[i].setSelected(false);
            this.textfelder[i].setEnabled(false);
            if (this.speichern || stand.exists()) {
                this.sicherungsbuttons[i].setEnabled(true);
                auswahlgruppe.add(i);
            } else {
                this.sicherungsbuttons[i].setEnabled(false);
            }
            ++i;
        }
        if (!auswahlgruppe.isEmpty()) {
            ((CardLayout)this.dialog.getLayout()).show(this.dialog, FORTSETZUNG);
            if (this.gewaehlt < 0) {
                this.pack();
                this.gewaehlt = this.speichern ? 0 : (Integer)auswahlgruppe.firstElement();
            }
            this.gewaehltVorAbbruch = this.gewaehlt;
            if (this.speichern) {
                this.textfelder[this.gewaehlt].setEditable(this.gewaehlt > 0);
                this.textfelder[this.gewaehlt].setEnabled(this.gewaehlt > 0);
                this.alterText = this.textfelder[this.gewaehlt].getText();
                this.altesDatum = this.sicherungsbuttons[this.gewaehlt].getText();
                this.sicherungsbuttons[this.gewaehlt].setText(String.valueOf(SCHACHTNAMEN[this.gewaehlt]) + " von jetzt");
            }
            this.sicherungsbuttons[this.gewaehlt].setSelected(true);
            this.fortsetzen.setText(text);
            this.fortsetzen.setActionCommand(cmd);
            this.fortsetzen.setEnabled(!this.speichern || this.gewaehlt > 0);
            this.getRootPane().setDefaultButton(this.fortsetzen);
        } else {
            ((CardLayout)this.dialog.getLayout()).show(this.dialog, LEER);
            this.pack();
            this.getRootPane().setDefaultButton(this.ok);
        }
    }

    private File datei(int i) {
        return this.eigenschaften.datei(DATEINAMENSBASIS + i + "." + DATEINAMENSENDUNG);
    }

    private void lade() {
        this.manager.betreibe(this.lade(0));
    }

    private Turnier lade(int index) {
        Turnier rekonstruktion = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.datei(index)));
            in.readObject();
            rekonstruktion = (Turnier)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(this, "Turnier kann nicht fortgesetzt werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
        return rekonstruktion;
    }

    private void meldeSpeicherung() {
        this.bestaetigung.setTitle("JaFuffy (Best\u00e4tigung)");
        this.bestaetigung.setIconImages(Oberflaeche.LOGOS);
        final JOptionPane meldung = new JOptionPane("Turnierstand erfolgreich gesichert!", 1);
        meldung.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (Fortsetzung.this.bestaetigung.isVisible() && e.getSource() == meldung && (prop.equals("value") || prop.equals("inputValue"))) {
                    Fortsetzung.this.bestaetigung.setVisible(false);
                    Fortsetzung.this.setVisible(false);
                }
            }
        });
        this.bestaetigung.setContentPane(meldung);
        this.bestaetigung.setModal(true);
        this.bestaetigung.pack();
        this.bestaetigung.setLocationRelativeTo(this.isVisible() ? this : this.getOwner());
        Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Fortsetzung.this.bestaetigung.setVisible(false);
                Fortsetzung.this.setVisible(false);
            }
        });
        timer.setRepeats(false);
        timer.start();
        this.bestaetigung.setVisible(true);
    }

    private void sichere(int index, Turnier sicherungsgut, String beschreibung) {
        if (!sicherungsgut.beendet()) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.datei(index)));
                out.writeObject(beschreibung == null || beschreibung.equals("") ? sicherungsgut.beschreibung() : beschreibung);
                boolean[] status = new boolean[5];
                int i = 0;
                while (i < 5) {
                    status[i] = sicherungsgut.wuerfel(i).darstellungsmodell().isSelected();
                    sicherungsgut.wuerfel(i).darstellungsmodell().setSelected(false);
                    ++i;
                }
                out.writeObject(sicherungsgut);
                i = 0;
                while (i < 5) {
                    sicherungsgut.wuerfel(i).darstellungsmodell().setSelected(status[i]);
                    ++i;
                }
                out.close();
                if (beschreibung != null) {
                    this.meldeSpeicherung();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Signal.ALARM.play();
                JOptionPane.showMessageDialog(this, "Turnierstand konnte nicht gespeichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
            }
        }
    }

    void setzeFort() {
        this.speichern = false;
        this.setTitle("JaFuffy (Turnier fortsetzen...)");
        this.belegeAuswahlMitDaten("Turnier fortsetzen", "Fortsetzen");
    }

    void speichere() {
        this.speichern = true;
        this.fortsetzen.setActionCommand("Speichern");
        this.fortsetzen.doClick();
    }

    void speichereUnter() {
        this.speichern = true;
        this.setTitle("JaFuffy (Turnier speichern unter...)");
        this.belegeAuswahlMitDaten("Turnier abspeichern", "Speichern");
    }
}

